<?php
// Created By gogetta.teams@gmail.com
// Please leave this in this script.
//https://github.com/gogetta69/TMDB-To-VOD-Playlist


require_once 'JavaScriptUnpacker.php';
require_once 'config.php';
accessLog();

if (isset($_GET['dev']) && $_GET['dev'] === 'true') {
$GLOBALS['DEBUG'] = true;	
}	
if (!$GLOBALS['DEBUG']) {
    error_reporting(0);	
} 	

////////////////////////////// Run Script ///////////////////////////////

cleanupCacheFiles(); // Check cache cleanup
//Run the script.
$expirationDuration = $expirationHours * 3600;

if (isset($_GET['movieId']) && !empty($_GET['movieId'])) {
    $movieId = $_GET['movieId'];

    $type = $_GET['type'] ?? 'movies';
    $episodeData = isset($_GET['data']) ? base64_decode($_GET['data']) : '';
} else {
    echo 'The movieId parameter was not passed or is empty!';
    exit();
}

$globalTitle = '';
$globalYear = '';
$logTitle = '';
$torrentData = [];
$deleteRDFiles = [];

//Run movies
if ($type == 'movies') {	
if (movieDetails_TMDB($movieId, $apiKey, $useRealDebrid) !== false) {
    http_response_code(404);
    echo "The requested resource was not found.";
	exit();
} else {
    echo "Should have redirected to the video.";
	exit();
}
//Run series
} elseif ($type == 'series'){
	$episodeData = explode(':', $episodeData);
	$subEpData = explode('/', $episodeData[1]);
	
	$movieId = $subEpData[0];
	
	//Store season number
	$seasonNoPad = $subEpData[2];
	$subEpData[2] = str_pad($subEpData[2], 2, "0", STR_PAD_LEFT);
	$season = $subEpData[2];
	//Store episode number
	$episodeNoPad = $subEpData[4];
	$subEpData[4] = str_pad($subEpData[4], 2, "0", STR_PAD_LEFT);
	$episode = $subEpData[4];
	$episodeId = 's'.$subEpData[2].'e'.$subEpData[4];
	$seriesCode = $episodeId;

	seriesDetails_TMDB($movieId, $apiKey, $useRealDebrid, $episodeData);
}

////////////////////////////// List of Functions ///////////////////////////////

////////////////////////////// The Movie Database ///////////////////////////////

function movieDetails_TMDB($movieId, $apiKey, $useRealDebrid)
{
    global $userDefinedOrder, $language, $usePremiumize;

    // Define the cache key
    $key = $movieId . '_tmdb_url';
		
	// Try to read the URL from cache
	$cachedUrl = readFromCache($key);	


	// If the URL is found in cache and hasn't expired, perform a 301 redirect
	if ($cachedUrl !== null) {
		if ($GLOBALS['DEBUG']) {
			echo "Service: Pulled from the cache - Url: " . $cachedUrl . "</br></br>";
			echo 'Debugging: Redirection to the video would have taken place here.</br></br>';
		} else {
			
			if($cachedUrl === '_failed_'){
				http_response_code(404);
				echo "The requested resource was not found.";
				exit();				
			}
			header("HTTP/1.1 301 Moved Permanently");
			header("Location: $cachedUrl");
			exit();
		}
	}

	
    $baseUrl = 'https://api.themoviedb.org/3/movie/';
    $url = $baseUrl . $movieId . '?api_key=' . $apiKey . '&language=' . $language;

    $response = @file_get_contents($url);

    if ($response !== false) {
        $movieData = json_decode($response, true);
        $imdbId = $movieData['imdb_id'];
        $title = $movieData['title'];
        $year = substr($movieData['release_date'], 0, 4);		
		$GLOBALS['globalTitle'] .= $title . ' ' . $year;
		$GLOBALS['logTitle'] .= $title . ' ' . '(' . $year . ')';
		$GLOBALS['globalYear'] .= $year;
        if ($imdbId) {
            if ($GLOBALS['DEBUG']) {
                // Log the extracted information
                echo 'IMDb ID: ' . $imdbId . "</br></br>";
                echo 'Title: ' . $title . "</br></br>";
                echo 'Year: ' . $year . "</br></br>";
            }

            $predefinedFunctions = ['theMovieArchive_site', 'shegu_net_links', 'primewire_tf', 'torrentSites', 'goMovies_sx', 'upMovies_to', 'superEmbed_stream', 'smashyStream_com', 'tvembed_cc', 'blackvid_space'];

            $successfulFunctionName = '';

            // Iterate through the user-defined order and execute functions accordingly
            foreach ($userDefinedOrder as $functionName) {
                if (in_array($functionName, $predefinedFunctions) && function_exists($functionName)) {
                    // Check if torrents should run.
                    if (!$useRealDebrid && !$usePremiumize && in_array($functionName, ['torrentSites'])) {
                        continue; //
                    }

                    // Define an array of parameters to pass to the function
                    $params = [$movieId, $imdbId, $title, $year];

                    if ($functionName == 'torrentSites') {
                        $params = [$movieId, $imdbId, $title, $year];
                    }

                    if ($functionName == 'shegu_net_links') {
                        $params = [$title, $year];
                    }


                    if ($functionName == 'theMovieArchive_site') {
                        $params = [$movieId, $title];
                    }
					
					if ($functionName == 'blackvid_space') {
                        $params = [$movieId, $title];
                    }
					
					if ($functionName == 'goMovies_sx') {
                        $params = [$title, $year];
                    }
					
					if ($functionName == 'upMovies_to') {
                        $params = [$title, $year];
                    }		

					if ($functionName == 'superEmbed_stream') {
                        $params = [$imdbId, $title, $year];
                    }
					if ($functionName == 'smashyStream_com') {
                        $params = [$movieId, $imdbId, $title];
                    }	
					
					if ($functionName == 'tvembed_cc') {
                        $params = [$movieId, $imdbId, $title];
                    }	

					if ($functionName == 'primewire_tf') {
                        $params = [$title, $year, $movieId, $imdbId];
                    }					

                    // Call the function with appropriate arguments
                    $result = call_user_func_array($functionName, $params);

                    // Check the result and continue or stop based on success
                    if ($result !== false) {
                        // Store the successful function name
                        $successfulFunctionName = $functionName;

                        if ($functionName !== 'torrentSites') {
							if (strpos($result, 'video_proxy.php') === false){
								$lCheck = checkLinkStatusCode($result);
							} else {
								$lCheck = true;
							}
                        } else {
                            $lCheck = true;
                        }

                        if ($GLOBALS['DEBUG']) {
                            // Log the extracted information with the successful function name
                            if ($lCheck !== false) {
                                echo "Service: " . $successfulFunctionName . ' - Url: ' . $result . "</br></br>";
                                echo 'Debugging: Redirection to the video would have taken place here.</br></br>';
                                writeToCache($key, $result);
                                exit();
                            }
                        } else {
                            // Put write to the cache here
                            if ($lCheck !== false) {
                                writeToCache($key, $result);
                                header("HTTP/1.1 301 Moved Permanently");
                                header("Location: $cachedUrl");
                                exit();
                            }
                        }
                    }
                }
            }
			if (!$GLOBALS['DEBUG']) {
				writeToCache($key, '_failed_', '60');
			 }
            http_response_code(404);
            echo "The requested resource was not found.";
            exit();

        } else {
            if ($GLOBALS['DEBUG']) {
                echo 'IMDb ID not found for the movie.' . "</br></br>";
            }
			if (!$GLOBALS['DEBUG']) {
				writeToCache($key, '_failed_', '60');
			 }
            http_response_code(404);
            echo "The requested resource was not found.";
            exit();
        }
    } else {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: Unable to retrieve movie details.' . "</br></br>";
        }
		if (!$GLOBALS['DEBUG']) {
			writeToCache($key, '_failed_', '60');
		}
        http_response_code(404);
        echo "The requested resource was not found.";
        exit();
    }
}

function seriesDetails_TMDB($movieId, $apiKey, $useRealDebrid, $episodeData)
{	
    global $userDefinedOrder, $episodeId, $language, $usePremiumize;
	

    // Define the cache key
    $key = $movieId . '_series_' . $episodeId . '_url';

    // Try to read the URL from cache
    $cachedUrl = readFromCache($key);

    // If the URL is found in cache and hasn't expired, perform a 301 redirect
	if ($cachedUrl !== null) {
		if ($GLOBALS['DEBUG']) {
			echo "Service: Pulled from the cache - Url: " . $cachedUrl . "</br></br>";
			echo 'Debugging: Redirection to the video would have taken place here.</br></br>';
		} else {
			
			if($cachedUrl === '_failed_'){
				http_response_code(404);
				echo "The requested resource was not found.";
				exit();				
			}
			header("HTTP/1.1 301 Moved Permanently");
			header("Location: $cachedUrl");
			exit();
		}
	}

    $baseUrl = 'https://api.themoviedb.org/3/tv/';
    $url = $baseUrl . $movieId . '?api_key=' . $apiKey . '&language=' . $language;

    $response = @file_get_contents($url);

    if ($response !== false) {
        $seriesData = json_decode($response, true);
        $imdbId = $episodeData[0];
		$title = $seriesData['name'];
        $setitle = $seriesData['name'].' '.$episodeId;
        $year = substr($seriesData['first_air_date'], 0, 4);
		$GLOBALS['globalYear'] .= $year;
		$GLOBALS['globalTitle'] .= $setitle;
		$GLOBALS['logTitle'] .= $title . ' ' . '(' . $year . ')' ;
		
        if ($imdbId) {
            if ($GLOBALS['DEBUG']) {
                // Log the extracted information
                echo 'IMDb ID: ' . $imdbId . "</br></br>";
                echo 'Title: ' . $title . "</br></br>";
                echo 'Year: ' . $year . "</br></br>";
            }	

            $predefinedFunctions = ['superEmbed_stream', 'shegu_net_links',
                'torrentSites', 'goMovies_sx', 'smashyStream_com', 'upMovies_to', 'primewire_tf', 'tvembed_cc', 'blackvid_space'];

            $successfulFunctionName = '';

            // Iterate through the user-defined order and execute functions accordingly
            foreach ($userDefinedOrder as $functionName) {
                if (in_array($functionName, $predefinedFunctions) && function_exists($functionName)) {
                    // Check if torrents should run.
                    if (!$useRealDebrid && !$usePremiumize && in_array($functionName, ['torrentSites'])) {
                        continue;
                    }

                    // Define an array of parameters to pass to the function
                    $params = [$movieId, $imdbId, $setitle, $year];

                    if ($functionName == 'torrentSites') {
                        $params = [$movieId, $imdbId, $setitle];
                    }

                    if ($functionName == 'shegu_net_links') {
                        $params = [$title, $year];
                    }
					
					if ($functionName == 'blackvid_space') {
                        $params = [$movieId, $title];
                    }
					
					if ($functionName == 'goMovies_sx') {
                        $params = [$title, $year];
                    }
					
					if ($functionName == 'upMovies_to') {
                        $params = [$title, $year];
                    }
					
					if ($functionName == 'superEmbed_stream') {
                        $params = [$imdbId, $title, $year];
                    }	
					
					if ($functionName == 'smashyStream_com') {
                        $params = [$movieId, $imdbId, $title];
                    }	
					
					if ($functionName == 'tvembed_cc') {
                        $params = [$movieId, $imdbId, $title];
                    }						
					
					if ($functionName == 'primewire_tf') {
                        $params = [$title, $year, $movieId, $imdbId];
                    }	

                    // Call the function with appropriate arguments
                    $result = call_user_func_array($functionName, $params);

                    // Check the result and continue or stop based on success
                    if ($result !== false) {
                        // Store the successful function name
                        $successfulFunctionName = $functionName;

                        if ($functionName !== 'torrentSites') {
                            $lCheck = checkLinkStatusCode($result);
                        } else {
                            $lCheck = true;
                        }

                        if ($GLOBALS['DEBUG']) {
                            // Log the extracted information with the successful function name
                            if ($lCheck !== false) {
                                echo "Service: " . $successfulFunctionName . ' - Url: ' . $result . "</br></br>";
                                echo 'Debugging: Redirection to the video would have taken place here.</br></br>';
                                writeToCache($key, $result);
                                exit();
                            }
                        } else {
                            // Put write to the cache here
                            if ($lCheck !== false) {
                                writeToCache($key, $result);
                                header("HTTP/1.1 301 Moved Permanently");
                                header("Location: $cachedUrl");
                                exit();
                            }
                        }
                    }
                }
            }
			if (!$GLOBALS['DEBUG']) {
				writeToCache($key, '_failed_', '60');
			}
            http_response_code(404);
            echo "The requested resource was not found.";
            exit();

        } else {
            if ($GLOBALS['DEBUG']) {
                echo 'IMDb ID not found for the movie.' . "</br></br>";
            }
			if (!$GLOBALS['DEBUG']) {
				writeToCache($key, '_failed_', '60');
			}
            http_response_code(404);
            echo "The requested resource was not found.";
            exit();
        }
    } else {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: Unable to retrieve movie details.' . "</br></br>";
        }
		if (!$GLOBALS['DEBUG']) {
			writeToCache($key, '_failed_', '60');
		}
        http_response_code(404);
        echo "The requested resource was not found.";
        exit();
    }
}

////////////////////////////// Real Debrid ///////////////////////////////

function instantAvailability_RD($hashes, $torrents){
    global $PRIVATE_TOKEN;
    $chunkSize = 100; // Adjust the chunk size as needed

    // Splitting the hashes array into chunks
    $hashChunks = array_chunk($hashes, $chunkSize);
    $combinedAvailabilityData = [];

    // Initialize the multi cURL handler
    $mh = curl_multi_init();
    $curlHandles = [];

    foreach ($hashChunks as $i => $chunk) {
        // Form the hash string for the API request
        $hashString = implode("/", $chunk);
        $url = "https://api.real-debrid.com/rest/1.0/torrents/instantAvailability/{$hashString}";

        // Initialize cURL session for each chunk
        $curlHandles[$i] = curl_init();
        curl_setopt($curlHandles[$i], CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curlHandles[$i], CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curlHandles[$i], CURLOPT_URL, $url);
        curl_setopt($curlHandles[$i], CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curlHandles[$i], CURLOPT_HTTPHEADER, ["Authorization: Bearer {$PRIVATE_TOKEN}"]);
        curl_multi_add_handle($mh, $curlHandles[$i]);
    }

    // Execute all queries simultaneously, and continue when all are complete
    $running = null;
    do {
        curl_multi_exec($mh, $running);
    } while ($running);

    // Collecting results
    foreach ($curlHandles as $ch) {
        $response = curl_multi_getcontent($ch);
        $availabilityData = json_decode($response, true);
        $combinedAvailabilityData = array_merge_recursive($combinedAvailabilityData, $availabilityData);
        curl_multi_remove_handle($mh, $ch);
        curl_close($ch);
    }

    curl_multi_close($mh);	

    // Filter the $torrents array based on combined availability data
    $torrents = array_filter($torrents, function($torrent) use ($combinedAvailabilityData) {
        $hash = strtolower($torrent['hash']);
        return isset($combinedAvailabilityData[$hash]) && !empty($combinedAvailabilityData[$hash]['rd']);
    });	
		
    return $torrents;
}

function addMagnetLink_RD($torrents, $magnetLink, $tSite, $tvpack)
{
    global $PRIVATE_TOKEN;	

    try {
		$url = 'https://api.real-debrid.com/rest/1.0/torrents/addMagnet';
		$postData = 'magnet=' . urlencode($magnetLink);
		$headers = [
			'Authorization: Bearer ' . $PRIVATE_TOKEN,
			'Content-Type: application/x-www-form-urlencoded',
		];
		
		$ch = curl_init($url);

		// Set cURL options
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
		
		$response = curl_exec($ch);
		
		$statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		
		curl_close($ch);
		
        if ($statusCode !== 200 && $statusCode !== 201) {
            if ($GLOBALS['DEBUG']) {
                echo 'HTTP Error Code: ' . $statusCode . "</br></br>";
                echo 'Error Response: ' . $response . "</br></br>";
            }
            return false;
        }
        $data = json_decode($response, true);
        $id = $data['id'];
        $uri = urldecode($data['uri']);
        if ($GLOBALS['DEBUG']) {
            echo 'ID: ' . $id . "</br></br>";
            echo 'URI: ' . $uri . "</br></br>";
        }
        return selectMultipleFiles_RD($torrents, $id, $tSite, $tvpack);
    }
    catch (exception $e) {
        if ($GLOBALS['DEBUG']) {
            echo "Error in addMagnetLink_RD: " . $e->getMessage() . "</br></br>";
        }
        return false; 
    }
}

function selectFile_RD($torrentId, $videoFileID, $tvpack)
{
    global $PRIVATE_TOKEN;

	echo "<br> Select File ID: " . $videoFileID. "<br><br>";

    try {
		
		$url = 'https://api.real-debrid.com/rest/1.0/torrents/selectFiles/' . $torrentId;		
		
		if ($tvpack) {
			$postData = 'files=all';
		} else {
			$postData = 'files=' . $videoFileID;
		}	

		$headers = [
			'Authorization: Bearer ' . $PRIVATE_TOKEN,
			'Content-Type: application/x-www-form-urlencoded',
		];
		
		$ch = curl_init($url);
		
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HEADER, true);
	
		$response = curl_exec($ch);
		
		$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$header = substr($response, 0, $header_size);
		$body = substr($response, $header_size);
		
		$statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		
		curl_close($ch);		

        // Define the array of error codes
        $errorCodes = [202 => 'Action already done', 400 =>
            'Bad Request (see error message)', 401 => 'Bad token (expired, invalid)', 403 =>
            'Permission denied (account locked, not premium)', 404 =>
            'Wrong parameter (invalid file id(s)) / Unknown resource (invalid id)',            
            ];

        // Check if the status code is in the array of error codes
        if (array_key_exists($statusCode, $errorCodes)) {
            if ($GLOBALS['DEBUG']) {
                echo 'HTTP Error Code: ' . $statusCode . "</br></br>";           

				// Output the error description
				echo 'Reason: ' . $errorCodes[$statusCode] . "</br></br>";

				echo 'Error Response: ' . $response . "</br></br>";
			}
			return false;
        } 

		if ($GLOBALS['DEBUG']) {				
			print_r('selectFile_RD - Response: ' .  $statusCode . "</br></br>");
		}
		return true;

    }
    catch (exception $e) {
        if ($GLOBALS['DEBUG']) {
            echo "Error in selectFile_RD: " . $e->getMessage() . "</br></br>";
        }
        return false; 
    }
}

function selectMultipleFiles_RD($torrents, $torrentId, $tSite, $tvpack)
{
    global $PRIVATE_TOKEN, $type, $episodeId;

    try {
		$url = 'https://api.real-debrid.com/rest/1.0/torrents/info/' . $torrentId;
		$headers = [
			'Authorization: Bearer ' . $PRIVATE_TOKEN,
			'Content-Type: application/x-www-form-urlencoded',
		];

		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($ch);
		$statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		curl_close($ch);
		
		
        if ($statusCode === 200) {
            if ($GLOBALS['DEBUG']) {
                echo 'HTTP Response Content: ' . $response . "</br></br>";
            }
        } else {
            if ($GLOBALS['DEBUG']) {
                echo 'HTTP Error Code: ' . $statusCode . "</br></br>";
                echo 'Error Response: ' . $response . "</br></br>";
            }
            return false;
        }
        $data = json_decode($response, true);
        $files = $data['files'];		
  
        $videoFileID = findVideoIndex_RD($files);
		
		if($videoFileID){
			
			selectFile_RD($torrentId, $files[$videoFileID['index']]['id'], $tvpack);			
			
			return getDlLink_RD($torrents, $torrentId, $tSite, $videoFileID['index'], $tvpack);
			
		} else {
			
			return false;			
		
		}

    }
    catch (exception $e) {
        if ($GLOBALS['DEBUG']) {
            echo "Error in selectMultipleFiles_RD: " . $e->getMessage() . "</br></br>";
        }
        return false;
    }
}

function findVideoIndex_RD($files) {
    global $type, $episodeId, $seriesCode;

    foreach ($files as $index => $file) { // Include $index in the loop
        echo "Find Video ID: " . $file['path'] . "<br><br>";

        // Skip files with 'sample' in their path
        if (stripos($file['path'], 'sample') !== false) {
            continue;
        }

        // If type is 'series', skip files where $seriesCode is not found in the path
        if ($type == 'series') {
            if (stripos(strtolower($file['path']), strtolower($seriesCode)) === false) {
                continue;
            }
        }

        // List of valid video extensions
        $videoExtensions = ['mp4', 'mkv', 'avi', 'mov', 'flv', 'wmv', 'mpg', 'mpeg', 'm4v'];
        $extension = strtolower(pathinfo($file['path'], PATHINFO_EXTENSION));
        
        if (in_array($extension, $videoExtensions)) {
            return [
                'index' => $index,
                'id' => $file['id']
            ];
        }
    }

    return false;
}

function getDlLink_RD($torrents, $torrentId, $tSite, $index, $tvpack)
{
	
	
    global $PRIVATE_TOKEN, $type, $deleteRDFiles;	

    try {
		$url = 'https://api.real-debrid.com/rest/1.0/torrents/info/' . $torrentId;
		$headers = [
			'Authorization: Bearer ' . $PRIVATE_TOKEN,
			'Content-Type: application/x-www-form-urlencoded',
		];

		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($ch);
		$statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		curl_close($ch);

        if ($statusCode === 200) {
            $data = json_decode($response, true);
			
			$linksArray = $data['links'];		
								
			if(!$tvpack){
				$index = 0;
			} 	else {
				// Filter out elements where 'selected' is 0
				$filteredFiles = array_filter($data['files'], function($file) {
					return $file['selected'] != 0;
				});

				$data['files'] = array_values($filteredFiles);
				$getindex = findVideoIndex_RD($data['files']);
				$index = $getindex['index'];             
			}				

/* 			echo "getDlLink_RD Index: " . $index . "<br><br>";
			echo "linksArray Links: " . print_r($linksArray);	
			echo "<br><br>";	 */
			
            if ($linksArray && count($linksArray) > 0) {
                $firstLink = $linksArray[$index];
			
                $payload = ['link' => $firstLink, 'remote' => 0, ];
                $context = stream_context_create(['http' => ['method' => 'POST', 'header' =>
                    implode("\r\n", $headers), 'content' => http_build_query($payload), ], ]);
                $unrestrictResponse = file_get_contents('https://api.real-debrid.com/rest/1.0/unrestrict/link', false,
                    $context);
                $unrestrictData = json_decode($unrestrictResponse, true);
                $downloadLink = $unrestrictData['download'];
                if ($GLOBALS['DEBUG']) {
				
                    echo 'getDlLink_RD - Video link: ' . $downloadLink . "</br></br>";
                }
                $fileNameMatch = preg_match('#/([^/]+)$#', $downloadLink, $fileNameMatches);
                if ($fileNameMatch) {
                    $filenameNoExt = urldecode($fileNameMatches[1]);
                } else {
                    $filenameNoExt = 'Unknown';
                }

                return $downloadLink;
            } else {
                if ($GLOBALS['DEBUG']) {

                    echo 'getDlLink_RD: No links found in the array.' . "</br></br>";

                }
				$deleteRDFiles[] = $torrentId;
                return false;
            }
        } else {
            if ($GLOBALS['DEBUG']) {
                echo 'HTTP Error Code: ' . $statusCode . "</br></br>";
                echo 'Error Response: ' . $response . "</br></br>";
            }
        }
    }
    catch (exception $e) {
        if ($GLOBALS['DEBUG']) {
            echo "Error in getDlLink_RD: " . $e->getMessage() . "</br></br>";
        }
		$deleteRDFiles[] = $torrentId;
        return false;
    }
}

function deleteFiles_RD($torrentIds) {
    global $PRIVATE_TOKEN;

    $mh = curl_multi_init();
    $curlHandles = [];

    foreach ($torrentIds as $torrentId) {
        $url = 'https://api.real-debrid.com/rest/1.0/torrents/delete/' . $torrentId;
        $headers = [
            'Authorization: Bearer ' . $PRIVATE_TOKEN,
            'Content-Type: application/x-www-form-urlencoded',
        ];

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        curl_multi_add_handle($mh, $ch);
        $curlHandles[$torrentId] = $ch;
    }

    $running = null;
    do {
        curl_multi_exec($mh, $running);
    } while ($running);

    foreach ($curlHandles as $torrentId => $ch) {
        $response = curl_multi_getcontent($ch);
        $statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if ($GLOBALS['DEBUG']) {
            if ($statusCode === 204) {
                echo 'Deleted File: ' . $torrentId . '</br></br> Response: ' . $response . '</br></br>';
            } else {
                echo 'HTTP Error Code: ' . $statusCode . "</br></br>";
                echo 'Error Response: ' . $response . "</br></br>";
            }
        }

        curl_multi_remove_handle($mh, $ch);
        curl_close($ch);
    }

    curl_multi_close($mh);

    // For simplicity, this function just executes the requests and logs the results.
    // It always returns true but you can modify it to handle errors more precisely.
    return true;
}

////////////////////////////// Premiumize ///////////////////////////////

function instantAvailability_PM($hashes, $torrents){
    global $premiumizeApiKey;
    $chunkSize = 100;
	try {
		// Splitting the hashes array into chunks
		$hashChunks = array_chunk($hashes, $chunkSize);
		$combinedAvailabilityData = [];

		// Initialize the multi cURL handler
		$mh = curl_multi_init();
		$curlHandles = [];

		foreach ($hashChunks as $i => $chunk) {
			
			$hashString = implode("&items%5B%5D=", $chunk);
			$url = "https://www.premiumize.me/api/cache/check?items%5B%5D={$hashString}&apikey={$premiumizeApiKey}";
			
			$curlHandles[$i] = curl_init($url);
			curl_setopt($curlHandles[$i], CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curlHandles[$i], CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($curlHandles[$i], CURLOPT_RETURNTRANSFER, true);
			curl_multi_add_handle($mh, $curlHandles[$i]);
		}
		
		$running = null;
		do {
			curl_multi_exec($mh, $running);
		} while ($running);

		// Collecting results
		foreach ($curlHandles as $ch) {
			$response = curl_multi_getcontent($ch);
			$availabilityData = json_decode($response, true);
			$combinedAvailabilityData = array_merge($combinedAvailabilityData, $availabilityData['response']);
			curl_multi_remove_handle($mh, $ch);
			curl_close($ch);
		}

		curl_multi_close($mh);

		if (count($hashes) !== count($availabilityData['response'])) {			
			throw new Exception("Premiumize: Mismatch in the number of hashes and response data");
		}
		
		$hashAvailabilityMap = array_combine($hashes, $availabilityData['response']);

		$torrents = array_filter($torrents, function($torrent) use ($hashAvailabilityMap) {
			$hash = strtolower($torrent['hash']);			
			return isset($hashAvailabilityMap[$hash]) && $hashAvailabilityMap[$hash] == 1;
		});
	} catch (Exception $e) {
		if ($GLOBALS['DEBUG']) {
			echo "Error: " . $e->getMessage();
		}
	}
    
    return $torrents;
}

function getStreamingLink_PM($torrents, $magnetLink, $tSite) {
    global $premiumizeApiKey, $globalTitle, $seriesCode, $type;

    $url = "https://www.premiumize.me/api/transfer/directdl";

    $postData = [
        'apikey' => $premiumizeApiKey,
        'src' => $magnetLink,
    ];

    // Initialize cURL session
    $ch = curl_init($url);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
		if ($GLOBALS['DEBUG']) {
			echo "cURL Error: " . curl_error($ch) . " in getStreamingLink_PM</br></br>";
		}  
        return false;
    }

    curl_close($ch);
    
    $responseData = json_decode($response, true);

	if (isset($responseData['content'])) {
		foreach ($responseData['content'] as $content) {			
			if (isset($content['path']) && $type == 'series') {
			
				$strippedPath = preg_replace('/[^a-zA-Z0-9]/', '', $content['path']);
				 
				if (stripos(strtolower($strippedPath), strtolower($seriesCode)) === false) {
					continue;
				}
			
			}
			if (isset($content['link']) && !empty($content['link']) && videoExtensionCheck($content['link'])) {
				return $content['link'];
			}
		}
	}
	
	if ($GLOBALS['DEBUG']) {
		echo "Couldn\'t get the streaming link in getStreamingLink_PM.</br></br>";
	} 

    return false;
}	

function videoExtensionCheck($url){
	
	$videoExtensions = ['mp4', 'mkv', 'avi', 'mov', 'flv', 'wmv', 'mpg', 'mpeg', 'm4v'];
	$extension = strtolower(pathinfo($url, PATHINFO_EXTENSION));
	
	if (in_array($extension, $videoExtensions)) {
		return true;
	} else {
		return false;
	}	
	
}	

////////////////////////////// Processing ///////////////////////////////

function sortTorrentsByQuality(&$torrents) {
    usort($torrents, function($a, $b) {
        // Check tvpack status
        $tvpackA = isset($a['tvpack']) && $a['tvpack'] == 1 ? 1 : 0;
        $tvpackB = isset($b['tvpack']) && $b['tvpack'] == 1 ? 1 : 0;

        if ($tvpackA != $tvpackB) {
            // Prioritize torrents without tvpack
            return $tvpackA - $tvpackB;
        }

        // If tvpack status is the same, then sort by quality
        $qualityA = intval(preg_replace('/[^0-9]/', '', $a['quality']));
        $qualityB = intval(preg_replace('/[^0-9]/', '', $b['quality']));

        // Sort in descending order
        return $qualityB - $qualityA;
    });
}

function filterTorrentsByResolution($torrents, $maxResolution) {
    $filteredTorrents = [];

    foreach ($torrents as $torrent) {
        $resolution = intval(preg_replace('/[^0-9]/', '', $torrent['quality']));
        if ($resolution == $maxResolution) {
            $filteredTorrents[] = $torrent;
        }
    }

    // If there are fewer than 5 torrents and additional items are available
    $additionalNeeded = 5 - count($filteredTorrents);
    if ($additionalNeeded > 0) {
        foreach ($torrents as $torrent) {
            if (count($filteredTorrents) >= 5) {
                break;
            }
            $resolution = intval(preg_replace('/[^0-9]/', '', $torrent['quality']));
            if ($resolution != $maxResolution) {
                $filteredTorrents[] = $torrent;
            }
        }
    }

    return $filteredTorrents;
}

function highlightMatch($text, $pattern) {    
    return str_ireplace($pattern, "<span style='background-color: #7fff26'>" . $pattern . "</span>", $text);
}

function filterCompareTitles($firstTitle, $secondTitle, $tvpack=false){
	
	global $season, $seasonNoPad, $globalTitle, $globalSeriesYear, $type;	
		
	//Replace non alphanumeric characters
    $firstTitle_adjusted = preg_replace('/[^a-zA-Z0-9]/', '', $firstTitle);
    $secondTitle_adjusted = preg_replace('/[^a-zA-Z0-9]/', '', $secondTitle);	
	
    $firstTitle_adjusted = strtolower($firstTitle_adjusted);
    $secondTitle_adjusted = strtolower($secondTitle_adjusted);
	
	// Check the first 3 characters match. Prevents 'Fear the Walking Dead' from matching 'The Walking Dead'.	
	if(substr($firstTitle_adjusted, 0, 3) !== substr($secondTitle_adjusted, 0, 3)){
		echo "<br>Original: ". $firstTitle . "<br>FILTERED! - Compare: " . $firstTitle_adjusted . ' to ' . $secondTitle_adjusted . "<br><br>";			
		return false;
	}	

	//If no year is found or the year doesn't match return false. (good for movies, not for tv shows)
	if ($type == 'movies' && strpos($firstTitle_adjusted, $GLOBALS['globalYear']) === false) {
		return false;
	} else {
		//Now strip the years from both titles before comparing.
		$firstTitle_adjusted = str_replace($GLOBALS['globalYear'], '', $firstTitle_adjusted);
		$secondTitle_adjusted = str_replace($GLOBALS['globalYear'], '', $secondTitle_adjusted);
	}	
	
	//Run this if tvpack is true..
	if($tvpack){
				
		//Replace 'complete season 1' with 'season 1' when comparing.
		$firstTitle_adjusted = str_replace('completeseason', 'season', $firstTitle_adjusted);
	
		//First compare the years to make sure they match.
		if(stripos($firstTitle_adjusted, $GLOBALS['globalYear']) !== false){
			//Strip the year if starting with 19 or 20
			$firstTitle_adjusted = preg_replace('/(19|20)\d{2}/', '', $firstTitle_adjusted);
			$secondTitle_adjusted = preg_replace('/(19|20)\d{2}/', '', $secondTitle_adjusted);
		}
		
		//Replace S01 with season1 if not followed by e01
		if(stripos($firstTitle_adjusted, 's'.$season) !== false){
			$firstTitle_adjusted = preg_replace('/s\d{2}(?!e\d{2})/', 'season'.$seasonNoPad, $firstTitle_adjusted);	
		}
        
		// Prevent double digit matching, this will match "season1" but not "season11
		$seasonRegex = "/season" . preg_quote($seasonNoPad, '/') . "(?!\d)/";
		if (!preg_match($seasonRegex, $firstTitle_adjusted)) {
			echo "<br>Original: ". $firstTitle . "<br>FILTERED! - Compare: " . $firstTitle_adjusted . ' to ' . $secondTitle_adjusted . "<br><br>";
			return false;
		}		

	}
	
    if (stripos($firstTitle_adjusted, $secondTitle_adjusted) !== false) {  
	if ($GLOBALS['DEBUG']) {
		$match = $secondTitle_adjusted;
		$highlightedFirstTitle = highlightMatch($firstTitle_adjusted, $match);
		$highlightedSecondTitle = highlightMatch($secondTitle_adjusted, $match);
		echo "<br>Original: " . $firstTitle . "<br>MATCHED! - Compare: " . $highlightedFirstTitle . ' to ' . $highlightedSecondTitle . "<br><br>";
	}	
        return true;
    } else {  
		echo "<br>Original: ". $firstTitle . "<br>FILTERED! - Compare: " . $firstTitle_adjusted . ' to ' . $secondTitle_adjusted . "<br><br>";
        return false;
    }
}	

function torrentSites($movieId, $imdbId, $title, $year=null){
	global $timeOut, $maxResolution, $torrentData, $type, $season, $episode, $seasonNoPad, $episodeNoPad, $useRealDebrid, $usePremiumize, $deleteRDFiles;	
		
	// The order of lines must match the same order & number of 	 
	// lines in the $processingFunctions array or errors will occur.
 	$requests = [];
	$requests[] = initialize_MagnetDL_com($movieId, $imdbId, $title, $year);
	$requests[] = initialize_bitLordSearch_com($movieId, $imdbId, $title, $year);
 	$requests[] = initialize_thepiratebay_org($movieId, $imdbId, $title, $year);
	$requests[] = initialize_torrentDownload_info($movieId, $imdbId, $title, $year);
	$requests[] = initialize_popcornTime($movieId, $imdbId, $title);
	$requests[] = initialize_torrentGalaxy_to($movieId, $imdbId, $title);
	$requests[] = initialize_glodls_to($movieId, $imdbId, $title, $year);
	$requests[] = ($type == "series") ? initialize_ezTV_re($movieId, $imdbId, $title) : null;	
	$requests[] = ($type == "movies") ? initialize_yts_mx($movieId, $imdbId, $title) : null;
	
	//Run addional threads to search for Season TV Pack.
	
	$seasonTitle = preg_replace('/s\d{2}e\d{2}/i', 'Season ' . $seasonNoPad, $title);
	
	$requests[] = ($type == "series") ? initialize_MagnetDL_com($movieId, $imdbId, $seasonTitle, $year, true) : null;
	$requests[] = ($type == "series") ? initialize_bitLordSearch_com($movieId, $imdbId, $seasonTitle, $year, true) : null;
	$requests[] = ($type == "series") ? initialize_thepiratebay_org($movieId, $imdbId, $seasonTitle, $year, true) : null;
	$requests[] = ($type == "series") ? initialize_torrentDownload_info($movieId, $imdbId, $seasonTitle, $year, true) : null;
	$requests[] = ($type == "series") ? initialize_popcornTime($movieId, $imdbId, $title, true) : null;		
	$requests[] = ($type == "series") ? initialize_torrentGalaxy_to($movieId, $imdbId, $seasonTitle, true) : null;
	$requests[] = ($type == "series") ? initialize_glodls_to($movieId, $imdbId, $seasonTitle, $year, true) : null;
	$requests[] = ($type == "series") ? initialize_ezTV_re($movieId, $imdbId, $seasonTitle, true) : null;
	$requests[] = ($type == "movies") ? initialize_yts_mx($movieId, $imdbId, $title) : null;

	
	$headers = [
		'Connection: keep-alive',
		'Accept: text/html, application/json'
	];
	
	// Initialize the multi cURL handler
	$mh = curl_multi_init();
	$curlHandles = [];
	$responses = [];

	foreach ($requests as $request) {
		if ($request === null) {
			continue;
		}
		$url = $request;		
			
		$ch = curl_init($url);
		
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_TIMEOUT, $timeOut);
		curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/119.0");
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		
		curl_multi_add_handle($mh, $ch);
		$curlHandles[] = $ch;
	}

	// Execute all queries simultaneously
	$running = null;
	do {
		curl_multi_exec($mh, $running);
		
	} while ($running);

	// Collect responses
	foreach ($curlHandles as $ch) {
		$response = curl_multi_getcontent($ch);
		$responses[] = $response;
		curl_multi_remove_handle($mh, $ch);
		curl_close($ch);
	}

	curl_multi_close($mh);		

	// Mapping the response processing functions
	$processingFunctions = [
		'magnetdl_com' => 'magnetdl_com',
		'bitLordSearch_com' => 'bitLordSearch_com',
		'thepiratebay_org' => 'thepiratebay_org',
		'torrentDownload_info' => 'torrentDownload_info',
		'popcornTime' => 'popcornTime',
		'torrentGalaxy_to' => 'torrentGalaxy_to',
		'glodls_to' => 'glodls_to',
 		'ezTV_re' => ($type == "series") ? 'ezTV_re' : null,
		'yts_mx' => ($type == "movies") ? 'yts_mx' : null,
		'magnetdl_com_TVPack' => ($type == "series") ? 'magnetdl_com' : null,
		'bitLordSearch_com_TVPack' => ($type == "series") ? 'bitLordSearch_com' : null,
 		'thepiratebay_org_TVPack' => ($type == "series") ? 'thepiratebay_org' : null,
		'torrentDownload_info_TVPack' => ($type == "series") ? 'torrentDownload_info' : null,
		'popcornTime_TVPack' => ($type == "series") ? 'popcornTime' : null,
		'torrentGalaxy_to_TVPack' => ($type == "series") ? 'torrentGalaxy_to' : null ,
		'glodls_to_TVPack' => ($type == "series") ? 'glodls_to' : null,
		'ezTV_re_TVPack' => ($type == "series") ? 'ezTV_re' : null,
		'yts_mx' => ($type == "movies") ? 'yts_mx' : null,		
		
		
	];
	
	$results = [];
	$i = 0;
	foreach ($processingFunctions as $key => $func) {
		if ($func !== null && isset($responses[$i])) {
			// Check if the key contains 'Pack'
			if (strpos($key, 'TVPack') !== false) {
				// Call the function with $responses[$i] and true
				$results[$key] = $func($responses[$i], true) ?: 0;
			} else {
				// Call the function normally
				$results[$key] = $func($responses[$i]) ?: 0;
			}
			$i++;
		}
	}

	$randomId = uniqid('id_', true);
	$hashedRandomId = md5($randomId . rand());

	$htmlContent = '<div id="'.$hashedRandomId.'" style="display: none;">';
	foreach ($results as $functionName => $value) {
		$htmlContent .= "<li>$functionName: $value</li>";
	}  
	
	$service = 'RealDebrid';

	if (!empty($torrentData && count($torrentData) > 0)) {		
		
		$returnedPremiumLink = '';
		
		//Run real debrid service.
		if($useRealDebrid === true && $service == 'RealDebrid'){
		$returnedPremiumLink = selectHashByPreferences($torrentData, $maxResolution, 'torrentSites', 'RealDebrid'); 
			if (count($deleteRDFiles) > 0) {
				// Run the deleteFiles_RD function to clean up.
				deleteFiles_RD($deleteRDFiles);
			}
		}	
		
		if(empty($returnedPremiumLink)){		
			if($useRealDebrid === true && $service == 'RealDebrid'){
				$pageUrl = 'https://real-debrid.com/';
				$htmlContent .= "<li>RealDebrid: 0</li>";
			}
			$service = 'Premiumize';
		}	
		
		//Run premiumize service.
		if($usePremiumize === true && $service == 'Premiumize'){
			$returnedPremiumLink = selectHashByPreferences($torrentData, $maxResolution, 'torrentSites', 'Premiumize'); 
		}	
		
		if($returnedPremiumLink !== false) {     

			if($useRealDebrid === true && $service == 'RealDebrid'){
				$pageUrl = 'https://real-debrid.com/';
				$htmlContent .= "<li>RealDebrid: $returnedPremiumLink[1]</li>";
			}
			if($usePremiumize === true && $service == 'Premiumize'){
				$pageUrl = 'https://premiumize.me/';
				$htmlContent .= "<li>Premiumize: $returnedPremiumLink[1]</li>";
			}		
			$htmlContent .= '</div><a href="javascript:void(0);" onclick="openPopup(\''.$hashedRandomId.'\')">Click to view...</a>'; 
			logDetails('torrentSites', $htmlContent, 'successful',$GLOBALS['logTitle'], $pageUrl, $returnedPremiumLink[0], $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');		
			
			return $returnedPremiumLink[0];
			
		} else {

			if($useRealDebrid === true && $service == 'RealDebrid'){
				$pageUrl = 'https://real-debrid.com/';
				$htmlContent .= "<li>RealDebrid: 0</li>";
			}
			if($usePremiumize === true && $service == 'Premiumize'){
				$pageUrl = 'https://premiumize.me/';
				$htmlContent .= "<li>Premiumize: 0</li>";
			}			

			$htmlContent .= '</div><a href="javascript:void(0);" onclick="openPopup(\''.$hashedRandomId.'\')">Click to view...</a>'; 
			logDetails('torrentSites', $htmlContent, 'failed', $GLOBALS['logTitle'], $pageUrl, 'n/a', $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');	

			return false;
		}
	} else {
		
		if($useRealDebrid === true && $service == 'RealDebrid'){
			$pageUrl = 'https://real-debrid.com/';
			$htmlContent .= "<li>RealDebrid: 0</li>";
		}
		if($usePremiumize === true && $service == 'Premiumize'){
			$pageUrl = 'https://premiumize.me/';
			$htmlContent .= "<li>Premiumize: 0</li>";
		}	

		$htmlContent .= '</div><a href="javascript:void(0);" onclick="openPopup(\''.$hashedRandomId.'\')">Click to view...</a>'; 
		logDetails('torrentSites', $htmlContent, 'failed', $GLOBALS['logTitle'], $pageUrl, 'n/a', $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');	

		return false;
	}	

}

function FindVideoExtractor($urlToCheck, $tSite, $referer, $identifier=null) {
	
	global $type;
	
    // The identifiers and their corresponding function.	
    $extractFunctions = [
        'vidmoly' => 'vidmolyExtract',
        'streamwish' => 'StreamwishExtract',
        'mixdrop' => 'MixdropExtract',
		'streamvid' => 'StreamvidExtract',   		
		'filelions' => 'FilelionsExtract',
		'denisegrowthwide' => 'VoeExtract',  
		'voe' => 'VoeExtract', 
		'voe' => 'VoeExtract',   	
		'rabbitstream' => 'UpCloudExtract',
		'vidcloud' => 'UpCloudExtract',
		'upcloud' => 'UpCloudExtract',
		'upstream' => 'UpstreamExtract',
		'eplayvid' => 'ePlayVidExtract',
		'jwstream' => 'twoEmbedExtract',	
		'2embed' => 'twoEmbedExtract',	
		'vipstream' => 'superEmbedVipExtract',	
		'streambucket' => 'superEmbedVipExtract',
		'streamtape' => 'streamtapeExtract',
		'tapenoads' => 'streamtapeExtract',
		//'vidoza' => 'vidozaExtract',	// Video wouldnt load during testing.		
    ];

	if($identifier == null){
		// Extract the host from the URL
		$parsedUrl = parse_url($urlToCheck);
		$host = $parsedUrl['host'];
		$parts = explode('.', $host);

		// Check if there are subdomains and exclude them
		if (count($parts) >= 2) {
			$identifierParts = array_slice($parts, -2);
			$identifier = implode('.', $identifierParts);
		} else {
			$identifier = $host;
		}
	}
	
    // Check if the identifier contains any of the keys in the array and execute the corresponding function
    $foundFunction = null;
    foreach ($extractFunctions as $key => $functionName) {
        if (stripos($identifier, $key) !== false) {
            $foundFunction = $functionName;
            break;
        }
    }

    if ($foundFunction !== null) {
		
		//If the url contains primewire get the actual host url.
		if(stripos($urlToCheck, 'primewire')){
			$urlToCheck = getLastRedirectUrl($urlToCheck);
		}

        $funcReturn = $foundFunction($urlToCheck, $tSite, $referer);
		
		if($funcReturn){
			$logStatus = 'successful';
		} else {
			$logStatus = 'failed';
		}			
		logDetails(isset($tSite) ? $tSite : 'unknown', $functionName, $logStatus, $GLOBALS['logTitle'], $urlToCheck, $funcReturn === false ? 'n/a' : $funcReturn, $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');
        
		return $funcReturn;
    } else {
       
		return false;
    }
}

function checkLinkStatusCode($url)
{
    // Existing code for checking 'video_proxy.php' and 'hls_proxy.php'
    if (strpos($url, 'video_proxy.php') !== false || strpos($url, 'hls_proxy.php')
        !== false) {
        return true;
    }

    // Check if the URL is empty
    if (empty($url)) {
        if ($GLOBALS['DEBUG']) {
            echo 'Link Checker - URL is empty.</br></br>';
        }
        return false;
    }

    // Check if the URL contains headers
    $headers = [];
    if (strpos($url, '|') !== false) {
        list($actualUrl, $headersStr) = explode('|', $url, 2);
        $headersStr = trim($headersStr);
        if (!empty($headersStr)) {
            $headersArr = explode('|', $headersStr);
            foreach ($headersArr as $header) {
                list($headerName, $headerValue) = explode('=', $header, 2);
                $headers[] = $headerName . ': ' . $headerValue;
            }
        }
        $url = $actualUrl;
    }

    // Create context options for the stream context
    $contextOptions = ['http' => ['header' => implode("\r\n", $headers)]];
    $context = stream_context_create($contextOptions);

    // Send a HEAD request to the URL
    $responseHeaders = @get_headers($url, 1, $context);

    if ($responseHeaders !== false) {
        // Extract the HTTP status code from the first header
        $httpStatus = explode(' ', $responseHeaders[0], 3);

        // Check for specific error codes
        if (isset($httpStatus[1]) && in_array($httpStatus[1], ['404', '503', '500',
            '400', '403'])) {
            if ($GLOBALS['DEBUG']) {
                echo 'Link Checker - The URL returned a ' . $httpStatus[1] .
                    ' status.</br></br>';
            }
            return false;
        }

        // Check Content-Type for video formats
        $contentType = isset($responseHeaders['Content-Type']) ? $responseHeaders['Content-Type'] :
            '';
        if (stripos($contentType, 'video') !== false || stripos($contentType, 'mpegurl')
            !== false) {
            if ($GLOBALS['DEBUG']) {
                echo 'Link Checker - Successful: The URL is accessible and valid for streaming.</br></br>';
            }
            return true;
        }

        if ($GLOBALS['DEBUG']) {
            echo 'Link Checker - The URL does not point to a valid video format.</br></br>';
        }
        return false;
    }

    if ($GLOBALS['DEBUG']) {
        echo 'Link Checker - Failed to fetch the URL or an error occurred.</br></br>';
    }
    return false;
}

function selectHashByPreferences($torrents, $maxResolution, $tSite, $service)
{
    global $PRIVATE_TOKEN, $usePremiumize, $useRealDebrid, $seasonNoPad;
	
	// Remove duplicate hashes from array.
	$uniqueTorrents = [];
	foreach ($torrents as $torrent) {
		$key = strtolower($torrent['hash']);
		if (!array_key_exists($key, $uniqueTorrents)) {
			$uniqueTorrents[$key] = $torrent;
		}
	}

	$torrents = array_values($uniqueTorrents);
	
    $selectedHash = null;
    $highestResolutionBelowMax = 0;
    $lowestResolutionAboveMax = INF;

    // Extract hashes from the torrents array
    $hashes = array_map(function ($torrent) {
        if (isset($torrent['hash'])) {
            return strtolower($torrent['hash']);
        }
        return null;
    }, $torrents);

    $hashes = array_filter($hashes, function ($value) {
        return $value !== null;
    });    
		
	$initialCount = count($torrents);
	
	$availableCountRealDebrid = $initialCount;
	$availableCountPremiumize = $initialCount;
	$filteredTorrentsRD = $torrents;
	$filteredTorrentsPM = $torrents;

	if ($useRealDebrid === true && $service === 'RealDebrid') {
		$filteredTorrentsRD = instantAvailability_RD($hashes, $torrents);
		
		if (count($filteredTorrentsRD) < $initialCount) {
			$availableCountRealDebrid = count($filteredTorrentsRD);
		}		
		
		$torrents = $filteredTorrentsRD;
	}
	
	if ($usePremiumize === true && $service === 'Premiumize') {
		$filteredTorrentsPM = instantAvailability_PM($hashes, $torrents);
		
		if (count($filteredTorrentsPM) < $initialCount) {
			$availableCountPremiumize = count($filteredTorrentsPM);
		}
		$torrents = $filteredTorrentsPM;
	}

	if (empty($torrents)) {
		if ($GLOBALS['DEBUG']) {
			echo "There were no cached torrents available for streaming.</br></br>";
		}
	return false;
	}	
	
    $selectedHash = null;	
	$attemptCount = 0;
	
	//Sort torrents from highest to lowest quality.
	sortTorrentsByQuality($torrents);
	
	$sortedTorrents = filterTorrentsByResolution($torrents, $maxResolution);	
	
    //Iterate through the torrents to find a suitable hash
	foreach ($torrents as $torrent) {
		
		// Set which hash to process.
		if (isset($sortedTorrents[$attemptCount])) {			
			 $selectedHash = $sortedTorrents[$attemptCount]['hash'];
		} else {
			$selectedHash = $torrent['hash'];
		}
		
		$selectedHash = $torrent['hash'];
		if ($useRealDebrid === true && $service == 'RealDebrid') {
			$addMagnetReturn = addMagnetLink_RD($torrents, 'magnet:?xt=urn:btih:' . $selectedHash, $tSite, $torrent['tvpack']);
			if ($addMagnetReturn) {
				return [
					$addMagnetReturn,
					$availableCountRealDebrid,
				];
			}        
		} elseif ($usePremiumize === true && $service == 'Premiumize') {
			$getStreamingLinkReturn = getStreamingLink_PM($torrents, 'magnet:?xt=urn:btih:' . $selectedHash, $tSite);
			if ($getStreamingLinkReturn) {
				return [
					$getStreamingLinkReturn,
					$availableCountPremiumize,
				];
			}
		}
		$attemptCount++;		
		if ($attemptCount >= 5){
			 return false;
		}
		
		
	}
	
	if ($GLOBALS['DEBUG']) {
		echo "No hash was found to be suitable.</br></br>";
	}
	return false;
}

function extractResolution($quality)
{
    $regex = '/(\d+)P/i';
    preg_match($regex, $quality, $match);

    if ($match && $match[1]) {
        return intval($match[1]);
    }
    return null;
}

function extractUpCloudKey($version = null) {
    $timeOut = 20;
    $context = stream_context_create(['http' => ['timeout' => $timeOut]]);
	$url = 'https://rabbitstream.net/js/player/prod/e4-player.min.js';
    $response = @file_get_contents($url, false, $context);
    
    if ($response === FALSE) {
        return json_encode(['error' => 'Could not retrieve the script.']); // Error in JSON format
    }

    $script = $response;

    $startOfSwitch = strrpos($script, "switch");
    $endOfCases = strpos($script, "partKeyStartPosition", $startOfSwitch);
    if ($startOfSwitch === false || $endOfCases === false) {
        return json_encode(['error' => 'Required patterns not found in the script.']); // Error in JSON format
    }
    $switchBody = substr($script, $startOfSwitch, $endOfCases - $startOfSwitch);

    $nums = [];
    preg_match_all('/:[a-zA-Z0-9]+=([a-zA-Z0-9]+),[a-zA-Z0-9]+=([a-zA-Z0-9]+);/', $switchBody, $matches, PREG_SET_ORDER);
    
    foreach ($matches as $match) {
        $innerNumbers = [];
        foreach (array_slice($match, 1) as $varMatch) {
            preg_match_all("/$varMatch=0x([a-zA-Z0-9]+)/", $script, $varMatches);
            $lastMatch = end($varMatches[1]);
            if (!$lastMatch) return json_encode(['error' => 'Failed to match the pattern in the script.']); // Error in JSON format
            $number = hexdec($lastMatch);
            $innerNumbers[] = $number;
        }

        $nums[] = $innerNumbers;
    }

    return json_encode($nums);
}

//Function for Primewire.tf (search key).
function generatePWSearchKey($query) {	
    $hardcodedKey = "hx4NNrPLs688H9x";
    $combinedString = $query . $hardcodedKey;
    $hashedString = sha1($combinedString);
    return substr($hashedString, 0, 10);
}

//Function for Primewire.tf (user data).
function decryptPWuserData($encryptedData) {
    // Check if encryptedData is provided
    if (!$encryptedData) {
        return false;
    }

    // Extract the last 10 characters as the key
    $key = substr($encryptedData, -10);

    // Remove the last 10 characters from encryptedData
    $encryptedData = substr($encryptedData, 0, -10);

    // Decode the remaining encryptedData
    $data = base64_decode($encryptedData);
    if ($data === false) {
        // Return false if base64_decode fails
        return false;
    }

    // Set decryption options
    $opts = OPENSSL_RAW_DATA | OPENSSL_DONT_ZERO_PAD_KEY | OPENSSL_ZERO_PADDING;

    // Decrypt the data
    $decrypted = openssl_decrypt($data, 'BF-ECB', $key, $opts);
    if ($decrypted === false) {
        // Return false if decryption fails
        return false;
    }

    // Split the decrypted string into parts of 5 characters each
    $keys = str_split($decrypted, 5);

    return $keys;
}

function getLastRedirectUrl($url) {
	
	global $timeOut;
	
    $ch = curl_init($url);

    // Set cURL options
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Follow redirects
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Return the transfer as a string
    curl_setopt($ch, CURLOPT_HEADER, true);         // Include the header in the output
    curl_setopt($ch, CURLOPT_NOBODY, true);         // No need to download the body
    curl_setopt($ch, CURLOPT_TIMEOUT, $timeOut);    // Set timeout

    // Set User-Agent
    curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0");

    // Execute the request
    curl_exec($ch);

    // Check if any error occurred
    if (!curl_errno($ch)) {
        $lastUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL); // Get the last effective URL
    } else {
        // Handle error, e.g., by throwing an exception or returning null
        $lastUrl = null;
    }

    // Close the cURL session
    curl_close($ch);

    return $lastUrl;
}

//Base64 Decode for upMovies_to
function decode64UpMovies($url) {
	global $timeOut;
    try {
        $context = stream_context_create([
            'http' => [
                'timeout' => $timeOut, 
                'header' => 'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0',
            ], 
        ]);

        $response = @file_get_contents($url, false, $context);

        // Check if the request was successful
        if ($response === false) {
            throw new Exception("Failed to fetch the URL: $url");
        }

        preg_match('#(?<=document\.write\(Base64\.decode\(").*?(?=")#', $response, $matches);

        if (isset($matches[0])) {
            $iframe = base64_decode($matches[0]);
            if (preg_match('#(?<=src=").*?(?=")#', $iframe, $iframeMatches)) {
                return $iframeMatches[0];
            }
        }

        throw new Exception("Couldn't find url in decoded base64 on page.");

    } catch (Exception $e) {        
        return false; // or return "Error: " . $e->getMessage();
    }
}

//Decryption for UpCloudExtract
function decryptUpcloudSource($encryptedString, $keySet)
{

    try { 
		
        $ch = curl_init();

        $url = "https://script.google.com/macros/s/AKfycbx5yZILYCNrg2gHFtzHxryKXyr6OKoUWdAKeoqnAUKc4JUWwBvMm5ZsbluqdEOsBVnb9A/exec?keyset=" . urlencode($keySet) . "&text=" . urlencode($encryptedString);		


        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

        $response = curl_exec($ch);

        if ($response === false) {
            throw new Exception("Curl error: " . curl_error($ch));
        }

        curl_close($ch);

        // Parse the JSON response to extract the file URL
        $data = json_decode($response, true);

        if ($data !== null && isset($data[0]['file'])) {
            // Extract the 'file' URL from the first element of the array
            $fileURL = $data[0]['file'];

            return $fileURL;
        } else {
            throw new Exception("Invalid JSON or 'file' key not found in response.");
        }
    }
    catch (exception $error) {
        // Handle the exception here
        echo "Error: " . $error->getMessage();
        return false;
    }
}

//Decryption for superEmbed_stream
function superEmbedBaseConvert($value, $fromBase, $toBase) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ+/';
    $fromCharacters = substr($characters, 0, $fromBase);
    $toCharacters = substr($characters, 0, $toBase);
    $decimalValue = 0;

    // Reversing the string and converting from the base $fromBase to decimal
    for ($i = 0; $i < strlen($value); $i++) {
        $decimalValue += strpos($fromCharacters, $value[$i]) * pow($fromBase, strlen($value) - $i - 1);
    }

    // Converting from decimal to the base $toBase
    $result = '';
    while ($decimalValue > 0) {
        $result = $toCharacters[$decimalValue % $toBase] . $result;
        $decimalValue = intdiv($decimalValue, $toBase);
    }
    
    return $result ?: '0';
}
//Decryption for superEmbed_stream
function superEmbedDecodeString($encodedString, $dictionary, $fromBase, $shift, $index) {
    $decoded = '';
    $len = strlen($encodedString);
    for ($i = 0; $i < $len; $i++) {
        $temp = '';
        while ($i < $len && $encodedString[$i] !== $dictionary[$index]) {
            $temp .= $encodedString[$i];
            $i++;
        }
        $temp = str_replace(str_split($dictionary), range(0, strlen($dictionary) - 1), $temp);
        $decoded .= chr(superEmbedBaseConvert($temp, $index, 10) - $shift);
    }
    return rawurldecode($decoded);
}

function decode_unicode_sequence($str) {
    return preg_replace_callback('/\\\\u([0-9a-fA-F]{4})/', function ($matches) {
        return mb_convert_encoding(pack('H*', $matches[1]), 'UTF-8', 'UCS-2BE');
    }, $str);
}

function decryptAesGCM($data, $pass) {
    
    function generateKeyAndIv($pass) {
        
        function getCurrentUTCDateString() {
            return gmdate('D, d M Y H:i:s') . ' GMT';
        }

        $datePart = substr(getCurrentUTCDateString(), 0, 16);
        $hexString = $datePart . $pass;
        $digest = hash('sha256', $hexString, true);

        $key = substr($digest, 0, 16);
        $iv = substr($digest, 16, 16);

        return array($key, $iv);
    }

    list($key, $iv) = generateKeyAndIv($pass);

    $tag = substr($data, -16);
    $ciphertext = substr($data, 0, -16);

    $decrypted = openssl_decrypt($ciphertext, 'aes-128-gcm', $key, OPENSSL_RAW_DATA, $iv, $tag);
    
    return $decrypted !== false ? $decrypted : false;
}

////////////////////////////// Direct Movies & Tv Shows Websites ///////////////////////////////

function primewire_tf($title, $year, $movieId, $imdbId)
{
	$primeWireDomain = 'https://www.primewire.tf';
	
    if ($GLOBALS['DEBUG']) {
        echo 'Started running primewire_tf </br></br>';
    }
	global $timeOut, $maxResolution, $type, $seasonNoPad, $episodeNoPad, $movieId;
	
    $tSite = 'primewire_tf';
	
	$apiUrl = $primeWireDomain . '/filter?s=' . $imdbId . '&ds=' . generatePWSearchKey($imdbId);		

    try {
        $context = stream_context_create(['http' => ['timeout' => $timeOut, 'header' =>
            'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0', ], ]);

        $response = @file_get_contents($apiUrl, false, $context);

        if ($response === false) {
            throw new Exception('HTTP Error: primewire_tf');
        }

    }
    catch (exception $error) {

        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
        }

        return false;
    }

    try {
        // Perform pattern matching to extract movie data
        if(preg_match('/(?<=<div class="index_item)[\s\S]*?(?=<\/div>)/', $response, $matches) && preg_match('/(?<=<a href=").*?(?=")/', $matches[0], $urlMatches)){			
			
			$detailsPage = $primeWireDomain . $urlMatches[0];
			
           if ($GLOBALS['DEBUG']) {
                echo "Details page found: <br>" . $detailsPage . "</br></br>";
            }				
			
		} else {
			throw new Exception("No search results found on primewire_tf");
		}

        $response = @file_get_contents($detailsPage, false, $context);
		
		if ($response === false) {
            throw new Exception('HTTP Error: primewire_tf');
        }
		
		//Get Season and episode page here if the type is series.
		
		if ($type == 'series'){
			if (preg_match('/(?<=<h2 class="tv_season_header">)[\s\S]*?(?=>)/', $response, $seBlock) && 
			preg_match('/(?<=data-id=").*?(?=")/', $seBlock[0], $seId)) {
				
				if (is_numeric($seId[0]) && strlen((string)$seId[0]) == 4) {
					$seIdNumber = is_numeric($seId[0]) ? (int)$seId[0] : 0;
					$seIdNumber = $seIdNumber + $seasonNoPad;
					$detailsPage = $detailsPage . '-season-' . $seIdNumber . '-episode-' . $episodeNoPad;
				} else {
					$detailsPage = $detailsPage . '-season-' . $seasonNoPad . '-episode-' . $episodeNoPad;
				}
				$pos = strpos($detailsPage, '-');
				$detailsPage = substr_replace($detailsPage, '/', $pos, 1);
				$response = @file_get_contents($detailsPage, false, $context);
				
				if ($response === false) {
					throw new Exception('HTTP Error: primewire_tf');
				}
			    if ($GLOBALS['DEBUG']) {
					echo "Series subpage found: <br>" . $detailsPage . "</br></br>";
				}				

			} else {
				throw new Exception("Couldn't get the series subpage on primewire_tf.");
			}				
		} 
		
		 if(preg_match('/(?<="user-data" v=").*?(?=")/', $response, $userData) && preg_match_all('/(?<=class="movie_version">)[\s\S]*?(?=<\/table>)/', $response, $textBlock)){
			 
			if ($GLOBALS['DEBUG']) {
                echo "Encrypted user-data string: <br>" . $userData[0] . "</br></br>";
            }
			
			$keys = decryptPWuserData($userData[0]);	
			
			if($keys === false){
				throw new Exception("user-data decryption failed on primewire_tf.");
			}	
			 
		 }	else {
				throw new Exception("No links found on primewire_tf.");
		 }


		$counter = 0; 
        foreach ($textBlock[0] as $divBlock) {
			
            
            if ($GLOBALS['DEBUG']) {
                echo "Looking for a match in textBlock: " . $counter . "</br></br>";
            }
						
			//Run the FindVideoExtractor function here.	
			if (preg_match('/host_id="\d+">\s*(.*?)\s*<\/span>/', $divBlock, $matches)) {
				$identifier = explode('.', $matches[1]);
				
				if(isset($keys[$counter])){
					$hostUrl = $primeWireDomain . '/links/go/' . $keys[$counter];
					$parsedUrl = parse_url($hostUrl);
					$referer = $parsedUrl['scheme'].$parsedUrl['host'];
					if ($GLOBALS['DEBUG']) {
                        echo 'Page containing ' . $identifier[0] . ': ' . $hostUrl . "</br></br>";
                    }
				} else {
				 continue;
				}
				
				$extractorReturn = FindVideoExtractor($hostUrl, $tSite, $referer, $identifier[0]);
				
				if ($extractorReturn !== false) {
				
                    return $extractorReturn;
                }
			}		


		$counter++;
        }


    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo "Couldn't locate an extractor for primewire_tf. </br></br>";
        }
	
        return false;
    }
    if ($GLOBALS['DEBUG']) {
        echo "Couldn't locate a link on primewire_tf. </br></br>";
    }
	
	return false;
}

function goMovies_sx($title, $year)
{
	    global $timeOut, $maxResolution, $type, $seasonNoPad, $episodeNoPad, $movieId;
		
    if ($GLOBALS['DEBUG']) {
        echo 'Started running goMovies_sx </br></br>';
    }
    global $timeOut;
    global $maxResolution;
    $tSite = 'goMovies_sx';

    $apiUrl = 'https://gomovies.sx/ajax/search';

    try {
        $postData = json_encode(['keyword' => $title, ]);

        $ch = curl_init();

        // Set cURL options
        curl_setopt($ch, CURLOPT_URL, $apiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, $timeOut);
        curl_setopt($ch, CURLOPT_USERAGENT,
            'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0');
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json', ]);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);

        $response = curl_exec($ch);


        if ($response === false) {
            throw new Exception('HTTP Error: goMovies_sx');
        }


        $doc = new DOMDocument();
        $doc->loadHTML($response);

        $divElements = $doc->getElementsByTagName('div');
        $matchingHref = null;

        $divElements = $doc->getElementsByTagName('a');


        foreach ($divElements as $a) {
            // Check if this <a> element has the expected class "nav-item"
            if ($a->getAttribute('class') == 'nav-item') {
                // Find the title and year elements within this <a> element
                $titleElement = $a->getElementsByTagName('h3')->item(0);
                $yearElement = $a->getElementsByTagName('span')->item(0);				

                if ($GLOBALS['DEBUG']) {
                    echo "Looking for a match by class: nav-item </br></br>";
                }

                // Check if the title and year match your criteria
				if (strtolower(trim($title)) == strtolower(trim($titleElement->textContent)) &&
					($type != 'movies' || strtolower(trim($year)) == strtolower(trim($yearElement->textContent)))){

                    // Get the href link
                    if ($a->getAttribute('href')) {
                        $Pagehref = "https://gomovies.sx" . $a->getAttribute('href');
                        if (preg_match('/(\d+)$/', $Pagehref, $matches)) {
                            $number = $matches[0];
                            if ($GLOBALS['DEBUG']) {
                                echo "Located watch id $number on goMovies_sx </br></br>";
                            }
							
							if ($type == "movies"){

								$url = "https://gomovies.sx/ajax/movie/episodes/" . $number;
							} else {
								
								$url = "https://gomovies.sx/ajax/season/list/" . $number;
							}
                            $context = stream_context_create(['http' => ['timeout' => $timeOut, 'header' =>
                                "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0\r\n",
                                "X-Requested-With: XMLHttpRequest"], ]);

                            $response = @file_get_contents($url, false, $context);					
													
							if ($type == "series"){
								$pattern = '/<a\s+data-id="(\d+)"\s*[^>]*\s*>Season\s+' . $seasonNoPad . '<\/a>/';
							if(!preg_match($pattern, $response, $matches)){
								throw new Exception('Couldn\'t locate season id on goMovies_sx');						 
							} else {
							if ($GLOBALS['DEBUG']) {
								 echo 'Located season id: ' . $matches[1] . "</br></br>";
							 }
							 $url ='https://gomovies.sx/ajax/season/episodes/' . $matches[1];
							 $response = @file_get_contents($url, false, $context);
							 $pattern = '/<a\s+id="episode-(\d+)"\s*[^>]*\s*Eps\s+' .$episodeNoPad.'\:/';
							if(!preg_match($pattern, $response, $matches)){
								throw new Exception('Couldn\'t episode id on goMovies_sx');						 
							} else {
							if ($GLOBALS['DEBUG']) {
								 echo 'Located episode id: ' . $matches[1] . "</br></br>";
							 }
							 $url ='https://gomovies.sx/ajax/episode/servers/' . $matches[1];
							 $response = @file_get_contents($url, false, $context);
							}								
							}
							}
							
                            if ($GLOBALS['DEBUG']) {
                                print_r('Video servers located: ' . $response . "</br></br>");
                            }
                            if ($response === false) {
                                throw new Exception('HTTP Error: goMovies_sx');
                            }
                            $doc = new DOMDocument();
                            $doc->loadHTML($response);

                            $xpath = new DOMXPath($doc);

                            $liElements = $xpath->query('//li[@class="nav-item"]');

                            if ($liElements !== null) {
                                foreach ($liElements as $li) {
                                    // Find the <a> element within the current <li> element
                                    $aElement = $xpath->query('.//a', $li)->item(0);

                                    if ($aElement !== null) {
                                        $title = $aElement->getAttribute('title');
										
										if($type == 'movies'){
											$dataLinkid = $aElement->getAttribute('data-linkid');
										} else {
											 $dataLinkid = $aElement->getAttribute('data-id');
										}
										
										if(!$title){
											continue;
										}	
                                        //Run the FindVideoExtractor function here.				
                                            
										if ($GLOBALS['DEBUG']) {
											echo "Page containing $title: $dataLinkid </br></br>";

										}
										
										try {
											$url = "https://gomovies.sx/ajax/sources/" . $dataLinkid;
											$response = @file_get_contents($url, false, $context);

											if ($response !== false) {
												// Decode the JSON data into an associative array
												$data = json_decode($response, true);

												if ($data !== null && isset($data['link'])) {
													if ($GLOBALS['DEBUG']) {
														print_r("The returned Json for $title: $response </br></br>");
													}
													
													$returnExtractor = FindVideoExtractor($data['link'], $tSite, 'https://gomovies.sx/', $title);
													if ($returnExtractor !== false) {
														
														return $returnExtractor;
													}
												}
											} else {
												throw new Exception("Couldn't find the $title on UpCloud for goMovies_sx");
											}
										} catch (Exception $e) {
											
											echo 'Caught exception: ', $e->getMessage();
										}                                     


                                    } else {
                                        throw new Exception('Couldn\'t locate links on goMovies_sx');
                                    }
                                }
                            } else {
                                if ($GLOBALS['DEBUG']) {
                                    echo "No <li> elements with class 'nav-item' found.\n";
                                }
                            }


                        } else {
                            throw new Exception('Couldn\'t get the watch id on goMovies_sx');
                        }

                    }
                }
            }
        }

    }
    catch (exception $error) {

        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
        }

        return false;
    }

    return false;
}

function upMovies_to($title, $year)
{
    if ($GLOBALS['DEBUG']) {
        echo 'Started running upMovies_to </br></br>';
    }
	global $timeOut, $maxResolution, $type, $seasonNoPad, $episodeNoPad, $movieId;
	
    $tSite = 'upMovies_to';

    $etitle = str_replace("%20", "+", urlencode($title));   
	
	if ($type == 'movies'){
		$searchQuery = $title . ' (' . $year . ')';
	} else {
		$searchQuery = $title . ' ' . $year . ' season ' . $seasonNoPad;	
	
	}
	
	$searchQuery = str_replace("%20", "+", urlencode($searchQuery));
	$apiUrl = 'https://upmovies.to/search-movies/' . $searchQuery . '.html';
	

    try {
        $context = stream_context_create(['http' => ['timeout' => $timeOut, 'header' =>
            'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0', ], ]);

        $response = @file_get_contents($apiUrl, false, $context);

        if ($response === false) {
            throw new Exception('HTTP Error: upMovies_to');
        }

    }
    catch (exception $error) {

        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
        }

        return false;
    }

    try {
		
        // Find the position of the media data.
		$pattern = '/(?<=<div class="itemBody">)[\s\S]*?(?=<div class="description">)/';
		
		if (preg_match_all($pattern, $response, $matches)) {
			foreach ($matches[0] as $index => $match) {
				
				$titlePattern = '/<div class="title"><a href="[^"]+">([^<]+)<\/a>/i';
				$yearPattern = '/<p>Year: (\d+)<\/p>/';

				if (preg_match($titlePattern, $match, $titleMatch) && preg_match($yearPattern, $match, $yearMatch)) {
					$extractedTitle = $titleMatch[1];
					$extractedYear = $yearMatch[1];	
										
					if ($type == 'movies'){
						$compareTitle = $title;
					} else {
						$compareTitle = $title . ': Season ' . $seasonNoPad;
					}
				
					if (strcasecmp($extractedTitle, $compareTitle) === 0 && $extractedYear == $year) {
					
						if (preg_match('/https:\/\/upmovies\.to\/watch.*?.html/', $match, $matches2)) {
							break;
						}
					}
				}
			}
		}


        if (empty($matches2)) {
            throw new Exception("No links found on upMovies_to.");
        }

        $response = @file_get_contents($matches2[0], false, $context);		
	
		if ($response === false) {
            throw new Exception('HTTP Error: upMovies_to');
        }
		
		if ($type == 'series'){			
			if(preg_match('/(?<=href=")[^"]*?episode-'.$episodeNoPad.'\.html(?=")/s', $response, $matches)){
			$response = @file_get_contents($matches[0], false, $context);
			
			} else {
			throw new Exception('Couldn\'t locate the episode page on upMovies_to.');
		}
			
		}
        
        if(!preg_match_all('/<div class="server_line[\s\S]*?<\/div>/s', $response, $matches)){
			throw new Exception('Couldn\'t locate the divBlock\'s on upMovies_to.');
		}

        foreach ($matches[0] as $divBlock) {
            
            if ($GLOBALS['DEBUG']) {
                echo "Looking for a match in div: " . $divBlock . "</br></br>";
            }
			
			//Run the FindVideoExtractor function here.
            if ($divBlock !== false) {

                $urlPattern = '/(?<=<a href=")([^"]+)(?=")/';

                if (preg_match($urlPattern, $divBlock, $urlMatches)) {
                    if ($GLOBALS['DEBUG']) {
                        echo 'Page containing source: ' . $urlMatches[1] . "</br></br>";

                    }	
					
					$srcUrl = decode64UpMovies($urlMatches[1]);
					if ($srcUrl !== false){
					   $extractorReturn = FindVideoExtractor($srcUrl, 'upMovies_to', 'https://upmovies.to/');
					if ($extractorReturn !== false) {
				
						return $extractorReturn;
					}
				}   

                }


            }

        }


    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo "Couldn't locate an extractor for upMovies_to. </br></br>";
        }

        return false;
    }
    if ($GLOBALS['DEBUG']) {
        echo "Couldn't locate a link on upMovies_to. </br></br>";
    }
	
	return false;
}

function superEmbed_stream($imdbId, $title, $year)
{
	    global $timeOut, $maxResolution, $type, $seasonNoPad, $episodeNoPad;
		
    if ($GLOBALS['DEBUG']) {
        echo 'Started running superEmbed_stream </br></br>';
    }
    global $timeOut;
    global $maxResolution;
    $tSite = 'superEmbed_stream';
	
	//$url = "https://multiembed.mov/directstream.php?video_id=" . $imdbId;
	$url = "https://multiembed.mov/?video_id=" . $imdbId;

	if ($type != "movies") {
		$url .= "&s=" . $seasonNoPad . "&e=" . $episodeNoPad;
	}

    try {
		$options = [
			'http' => [
				'method' => "GET",
				'header' => //"Referer: https://streambucket.net/\r\n" .
							"User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/118.0\r\n",
				'timeout' => $timeOut,
			]
		];
		$context = stream_context_create($options);

		$content = @file_get_contents($url, false, $context);	

		if (preg_match('/(?<=decodeURIComponent\(escape\(r\)\))[\s\S]*?\)/', $content, $matches)) {
			
			$extractedString = $matches[0];
			
			if ($GLOBALS['DEBUG']) {
				echo 'Encrypted data extracted: ' . $extractedString . "</br></br>";
			}
			
			$extracted = str_getcsv($matches[1]);
			

		if (preg_match('/\((.*)\)/', $extractedString, $matches)) {		


			$decryptedData = superEmbedDecodeString($extracted[0], $extracted[2], $extracted[1], $extracted[3], $extracted[4]);
			if (preg_match('/(?<=file:").*?(?=")/', $decryptedData, $matches)) {
				
				return $matches[0];
			} else {

				throw new Exception('Couldn\'t find the file link on superEmbed_stream.');
			}				
		
		} else {
			throw new Exception('Couldn\'t locate the encrypted host on superEmbed_stream.');
		}	   
		} else {			

			//Try and get the list of sources.
			if (preg_match('/(?<=document\.referrer\);var w=btoa\(").*?play.*?(?=")/', $content, $matches) && preg_match('/(?<=play=)(.*)/', $matches[0], $token)) {	

				$apiurl = "https://streambucket.net/?play=" . urlencode($token[1]);

				$options = [
					'http' => [
						'method' => 'POST',
						'header' => "Referer: https://streambucket.net/\r\n" .
									"User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/118.0\r\n" .
									"X-Requested-With: XMLHttpRequest\r\n",
						'content' => 'button-click=ZEhKMVpTLVF0LVBTLVF0TmpnNExTLVF5TkRndEwtMC1WMk8tMGc1LVB6VXdPREl5T0RZLTU%3D&button-referer=',
						'timeout' => $timeOut,
					],
				];
				$context = stream_context_create($options);
				$content = @file_get_contents($apiurl, false, $context);				

				if (preg_match('/(?<=load_sources\(").*?(?="\))/', $content, $token2)) {	
					if ($GLOBALS['DEBUG']) {
						echo 'Found the 2nd token: ' . $token2[0] . '</br></br>';
					}
				} else {
					throw new Exception('Couldn\'t locate the 2nd token on superEmbed_stream.');
				}
				
				$url = "https://streambucket.net/response.php";

				$options = [
					'http' => [
						'method' => 'POST',
						'header' => "Referer: $apiurl\r\n" .
									"Origin: https://streambucket.net\r\n" .
									"User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/118.0\r\n" .
									"X-Requested-With: XMLHttpRequest\r\n",
						'content' => 'token=' . urlencode($token2[0]),
						'timeout' => $timeOut,
					],
				];
				$context = stream_context_create($options);
				$content = @file_get_contents($url, false, $context);			
	
				
				if (preg_match_all('/<li data-id="[\s\S]*?<\/li>/', $content, $servers)) {

					if ($GLOBALS['DEBUG']) {
						echo 'Found the list of servers: </br>';
					}
					// Loop through servers to find a matching extractor.
					foreach ($servers as $serverGroup) {
						foreach ($serverGroup as $server) {

							if (!is_string($server)) {
								continue;
							}

							// Extract data-id value
							preg_match('/data-id="([^"]+)"/', $server, $dataIdMatches);
							$dataId = $dataIdMatches[1] ?? null;

							// Extract data-server value
							preg_match('/data-server="(\d+)"/', $server, $dataServerMatches);
							$dataServer = $dataServerMatches[1] ?? null;

							// Extract server name
							preg_match('/server-image server-(\w+).*?<\/div>\s*(\w+)/', $server, $serverNameMatches);
							$serverName = $serverNameMatches[2] ?? null;

							$formUrl = "https://streambucket.net/playvideo.php?video_id=" . urlencode($dataId) . "&server_id=" . urlencode($dataServer) . "&token=" . urlencode($token2[0]) . "&init=0";

							$options = [
								'http' => [
									'method' => "GET",
									'header' => "Referer: https://streambucket.net/\r\n" .
												"User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/118.0\r\n",
									'timeout' => $timeOut,
								]
							];
							$context = stream_context_create($options);

							if ($GLOBALS['DEBUG']) {
								echo "Server Name: $serverName, Data ID: $dataId, Data Server: $dataServer<br>";
							}

							//Run the FindVideoExtractor function here.
							if ($serverName) {

								$content = @file_get_contents($formUrl, false, $context);			
								
								if (preg_match('/(?<=frameborder="0" src=").*?(?=" scrolling="no")/', $content, $hostUrl)) {
									if ($GLOBALS['DEBUG']) {
										echo "Found $serverName url: " . $hostUrl[0] . "</br></br>";
									}
									$DirectLink = FindVideoExtractor($hostUrl[0], 'superEmbed_stream', 'https://streambucket.net/', $serverName);
									if ($DirectLink !== false) {										

										return $DirectLink;
									}
								} else {
										
									if ($GLOBALS['DEBUG']) {
										echo 'Couldn\'t locate the upstream url for superEmbed_stream.</br>';
									}

								}

							}

							
						}

					}

				} else {
					throw new Exception('Couldn\'t get the source list on superEmbed_stream.');
				}
				
				
			} else {
				throw new Exception('Couldn\'t get the source list on superEmbed_stream.');
			}
		}

    }
    catch (exception $error) {

        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
        }
			
        return false;
    }

    return false;
}

function smashyStream_com($movieId, $imdbId, $title)
{
    global $timeOut, $maxResolution, $type, $seasonNoPad, $episodeNoPad;

    $tSite = 'Smashy Stream';
	
	if ($GLOBALS['DEBUG']) {
        echo 'Started running smashyStream_com </br></br>';
    }	

	if ($type == 'movies'){
		$searchQuery = $movieId;
	} else {
		$searchQuery = $movieId . '&season=' . $seasonNoPad . '&episode=' . $episodeNoPad;
	}

	$apiUrl = "https://embed.smashystream.com/playere.php?tmdb=$searchQuery";	
	
	try {
		
				$contextOptions = [
			'http' => [
				'method' => "GET",
				'header' => "Accept-Language: en-US,en;q=0.5\r\n" .	
							"Accept: application/json, text/javascript,*; q=0.01\r\n" .
							"X-Requested-With: XMLHttpRequest\r\n" .							
							"User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/119.0\r\n" .
							"Referer: $apiUrl\r\n",
				'timeout' => $timeOut,
			]
		];		
				
		$context = stream_context_create($contextOptions);
		$response = file_get_contents($apiUrl, false, $context);
		
		
		if ($response === false) {
            throw new Exception('HTTP Error: smashyStream_com');
		}				

		if(!preg_match_all('/(?<=data-url=")htt.*?tmdb\=/', $response, $urlMatches)){	
		 
			throw new Exception("No links found on smashyStream_com.");		
			
		 }		
		 		 
		$firstSourceUrl = null;
		
		if (!empty($urlMatches) && is_array($urlMatches[0])) {
			foreach ($urlMatches[0] as $apiUrl) {				

				if ($type == 'movies'){
					$apiUrl = $apiUrl . $movieId;
				} else {
					$apiUrl = $apiUrl . $movieId . '&season=' . $seasonNoPad . '&episode=' . $episodeNoPad;
				}
				

				$context = stream_context_create($contextOptions);
				$response = file_get_contents($apiUrl, false, $context);		

				if ($response !== false) {
					$jsonArray = json_decode($response, true);
					if (isset($jsonArray['sourceUrls']) && is_array($jsonArray['sourceUrls']) && !empty($jsonArray['sourceUrls'][0])) {

						$firstSourceUrl = $jsonArray['sourceUrls'][0];	
						
						if ($GLOBALS['DEBUG']) {
							echo "Video link: " . $firstSourceUrl . "<br><br>";
						}						
						break;
					}
				}	

			}
			
		} else {
			throw new Exception("No links found on smashyStream_com.");
		}	

        
        if(!$firstSourceUrl){
			throw new Exception("No links found on smashyStream_com.");
		} 		
		
		logDetails('smashyStream_com', 'none', 'successful', $GLOBALS['logTitle'], $apiUrl, $firstSourceUrl, $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');		
   
        return $firstSourceUrl;
  
    } catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running smashyStream_com </br></br>';
        }
		logDetails('smashyStream_com', 'none', 'failed', $GLOBALS['logTitle'], $apiUrl, 'n/a', $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');

        return false;
    }
}

// API changed to using an encryption (need to figure this out).
function theMovieArchive_site($movieId, $title)
{
    global $timeOut, $movieId, $type;

    if ($GLOBALS['DEBUG']) {
        echo 'Started running theMovieArchive_site </br></br>';
    }

    $url = "https://prod.omega.themoviearchive.site/v3/movie/sources/" . $movieId;
    $options = ['http' => ['method' => "GET", 'header' =>
        "Content-Type: application/json"]];

    try {
        $context = stream_context_create(['http' => ['timeout' => $timeOut]]);
        $response = @file_get_contents($url, false, $context);
        if ($response === false) {
            throw new Exception('HTTP Error: theMovieArchive_site</br></br>');
        }
    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Failed to fetch movie source data from theMovieArchive_site Error: ' . $error->
                getMessage() . "</br></br>";
            echo 'Finished running theMovieArchive_site </br></br>';

        }
			logDetails($title, $url, 'n/a', 'movie', $movieId, 'failed', $type === 'series' ? $seasonNoPad : '', $type === 'series' ? $episodeNoPad : '');
        return false;
    }

    $statusCode = http_response_code(); // Get the current response status code
    if ($statusCode !== 200) {
        if ($GLOBALS['DEBUG']) {
            echo "Failed to fetch movie source data from theMovieArchive_site Response code: " .
                $statusCode . "<br></br>";
            echo 'Finished running theMovieArchive_site </br></br>';
        }
			logDetails($title, $url, 'n/a', 'movie', $movieId, 'failed', $type === 'series' ? $seasonNoPad : '', $type === 'series' ? $episodeNoPad : '');
        return false;
    }

    $data = json_decode($response, true);

    if ($data && isset($data['sources'])) {
        $foundUrl = false;
        // Define the qualities to check
        $qualitiesToCheck = ['2160', '1080', '720', 'auto'];

        foreach ($data['sources'] as $source) {
            foreach ($source['sources'] as $videoSource) {
                $quality = $videoSource['quality'];
                $vurl = $videoSource['url'];

                if (in_array($quality, $qualitiesToCheck)) {

                    if ($GLOBALS['DEBUG']) {
                        echo 'Video Link: ' . $vurl . "</br></br>";

                    }
						logDetails($title, $url, $vurl, $type, $movieId, 'successful', $type === 'series' ? $seasonNoPad : '', $type === 'series' ? $episodeNoPad : '');					
                    return $vurl;


                }
            }
        }

        if ($GLOBALS['DEBUG']) {
            echo "No suitable URL found. </br></br>";
        }
        echo 'Finished running theMovieArchive_site </br></br>';
			logDetails($title, $url, 'n/a', 'movie', $movieId, 'failed', $type === 'series' ? $seasonNoPad : '', $type === 'series' ? $episodeNoPad : '');			
        return false;
    } else {

        if ($GLOBALS['DEBUG']) {
            echo "No sources found in the JSON data.";
        }
        echo 'Finished running theMovieArchive_site </br></br>';
			logDetails($title, $url, 'n/a', 'movie', $movieId, 'failed', $type === 'series' ? $seasonNoPad : '', $type === 'series' ? $episodeNoPad : '');		
        return false;
    }
}

function shegu_net_links($title, $year)
{
    if ($GLOBALS['DEBUG']) {
        echo 'Started running shegu_net_links </br></br>';
    }

    global $maxResolution, $type, $seasonNoPad, $episodeNoPad, $movieId;
    $movieIdShe = null; // Initialize $movieIdShe to null

    // Define constants
    $iv = base64_decode("d0VpcGhUbiE=");
    $key = base64_decode("MTIzZDZjZWRmNjI2ZHk1NDIzM2FhMXc2");
    $sites = [base64_decode("aHR0cHM6Ly9zaG93Ym94LnNoZWd1Lm5ldC9hcGkvYXBpX2NsaWVudC9pbmRleC8="),
        base64_decode("aHR0cHM6Ly9tYnBhcGkuc2hlZ3UubmV0L2FwaS9hcGlfY2xpZW50L2luZGV4Lw=="), ];
    $appName = base64_decode("bW92aWVib3g=");
    $appId = base64_decode("Y29tLnRkby5zaG93Ym94");

    $searchParams = ["module" => "Search3", "page" => "1", "type" => "all",
        "keyword" => $title, "pagelimit" => "20",
        ];

    $searchResponse = shegu_net_request($searchParams, false);

    if (isset($searchResponse['msg']) && $searchResponse['msg'] ===
        'no search result') {
        if ($GLOBALS['DEBUG']) {
            echo 'Search shegu_net_request Response: </br></br>';
            print_r($searchResponse);
            echo '</br></br>';
            echo 'Finished running shegu_net_links </br></br>';

        }
		
			logDetails('shegu_net_links', 'none', 'failed', $GLOBALS['logTitle'], $sites[0], 'n/a', $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');			

        return false;
    }

    if ($GLOBALS['DEBUG']) {
        echo 'Search shegu_net_request Response: </br></br>';
        print_r($searchResponse);
        echo "</br></br>";
    }

    foreach ($searchResponse['data'] as $movie) {
        if ($movie['year'] == $year) {
            $movieIdShe = $movie['id'];
            break; // exit the loop once the correct year is found
        }
    }

    if ($movieIdShe !== null) {
        // $movieIdShe contains the id of the movie with the matching year
        if ($GLOBALS['DEBUG']) {
            echo "Movie ID: " . $movieIdShe . '</br></br>';
        }
    } else {
        if ($GLOBALS['DEBUG']) {
            echo "No movie found for the specified year.</br></br>";
            echo 'Finished running shegu_net_links </br></br>';
        }
			logDetails('shegu_net_links', 'none', 'failed', $GLOBALS['logTitle'], $sites[0], 'n/a', $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');		
	
        return false;
    }

if ($type == 'movies'){
    // Call the sub-function again to get the download URLs using the movie ID
$urlParams = [
    "module" => "Movie_downloadurl_v3",
    "mid"    => $movieIdShe,
    "oss"    => "1",
    "group"  => "",
    // ...
];

} else {
	  // Call the sub-function again to get the download URLs using the tv ID
$urlParams = [
    "module"  => "TV_downloadurl_v3",
    "tid"     => $movieIdShe,
    "season"  => $seasonNoPad,
    "episode" => $episodeNoPad,
    "oss"     => "1",
    "group"   => ""
];

}
		
		
    $urlResponse = shegu_net_request($urlParams, false);

	if ($urlResponse === false || !isset($urlResponse['data']['list']) ||!is_array($urlResponse['data']['list']) || empty($urlResponse['data']['list'])) {
		
	if ($GLOBALS['DEBUG']) {
		echo "The First attempt response:<br>";
		 print_r($urlResponse);
		 echo "</br><br>";
		echo "The first URL attempt was unsuccessful. Initiating attempt with the second URL.<br>";
	}
	$urlResponse = shegu_net_request($urlParams, true);
	}

    // Process the URLs and return the appropriate one based on $maxResolution
    if (isset($urlResponse['data']['list'])) {

        $urls = $urlResponse['data']['list'];
        if ($GLOBALS['DEBUG']) {
            echo 'Get Links shegu_net_request Response: </br></br>';
            print_r($urlResponse);
            echo "</br><br>";
        }

    } else {
        if ($GLOBALS['DEBUG']) {
            echo 'Failed to get links from shegu_net_request. </br></br>';
            echo 'Finished running shegu_net_links </br></br>';
        }

			logDetails('shegu_net_links', 'none', 'failed', $GLOBALS['logTitle'], $sites[0], 'n/a', $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');			

        return false;
    }
    function convertQualityToInt($quality)
    {
        // If the quality is '4K', return 2160
        if (strtolower($quality) == '4k') {
            return 2160;
        }

        // Remove the 'p' or 'P' character and convert the remaining string to an integer
        return intval(str_ireplace('p', '', $quality));
    }

    // Initialize variables
    $closestDifference = PHP_INT_MAX;
    $closestQuality = null;
    $closestMovie = null;

    // Loop through the array of movies
    foreach ($urls as $movie) {

        if (empty($movie['path'])) {
            continue;
        }

        // Convert the real_quality value to an integer for comparison
        $realQuality = convertQualityToInt($movie['real_quality']);

        // Calculate the difference between the real_quality and the maxResolution
        $difference = abs($realQuality - $maxResolution);

        if ($GLOBALS['DEBUG']) {
            echo "Movie video path: " . $movie['path'] . "<br><br>";
        }

        // Check if this movie is a closer match than the previous closest match
        if ($difference < $closestDifference) {
            $closestQuality = $realQuality;
            $closestDifference = $difference;
            $closestMovie = $movie;
        }
    }

    // Check if a closest match was found
    if ($closestMovie !== null) {
        // $closestMovie contains the movie version with the closest available quality

        if ($GLOBALS['DEBUG']) {
            echo "Closest Quality: " . $closestQuality . "</br><br>";
            echo "Movie Path: " . $closestMovie['path'] . "</br><br>";

        }

    } else {
        if ($GLOBALS['DEBUG']) {
            echo "No movie found with the closest quality.</br><br>";
        }
    }

    if (isset($closestMovie['path'])) {		

		
			logDetails('shegu_net_links', 'none', 'successful', $GLOBALS['logTitle'], $sites[0], $closestMovie['path'], $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');	
			

        return $closestMovie['path'];
    } else {
        if ($GLOBALS['DEBUG']) {
            echo 'Finished running shegu_net_links </br></br>';

        }
			logDetails('shegu_net_links', 'none', 'failed', $GLOBALS['logTitle'], $sites[0], 'n/a', $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');				
        return false;
    }
}

function shegu_net_request($data, $useSecondUrl = false)
{
    global $timeOut;
    // Define constants
    $iv = base64_decode("d0VpcGhUbiE=");
    $key = base64_decode("MTIzZDZjZWRmNjI2ZHk1NDIzM2FhMXc2");
    $urls = [base64_decode("aHR0cHM6Ly9zaG93Ym94LnNoZWd1Lm5ldC9hcGkvYXBpX2NsaWVudC9pbmRleC8="),
        base64_decode("aHR0cHM6Ly9tYnBhcGkuc2hlZ3UubmV0L2FwaS9hcGlfY2xpZW50L2luZGV4Lw=="), ];
    $appName = base64_decode("bW92aWVib3g=");
    $appId = base64_decode("Y29tLnRkby5zaG93Ym94");

    // Helper function to encrypt data using 3DES
    $encrypt = function ($data, $key, $iv)
    {
        return openssl_encrypt($data, 'des-ede3-cbc', $key, 0, $iv);
    }
    ;

    // Helper function to get verify token
    $getVerify = function ($encryptedData, $appName, $key)
    {
        return $encryptedData ? md5(md5($appName) . $key . $encryptedData) : null;
    }
    ;

    // Helper function to get the current timestamp plus 12 hours
    $getExpiredDate = function ()
    {
        return time() + 60 * 60 * 12;
    }
    ;

    // Define request parameters
    $params = ["childmode" => "0", "app_version" => "11.5", "appid" => $appId,
        "lang" => "en", "expired_date" => (string )time() + 60 * 60 * 12, "platform" =>
        "android", "channel" => "Website", "uid" => "", // ... (other parameters)
        ];

    // Merge input data with default parameters
    $requestData = array_merge($params, $data);

    // Encrypt the request data
    $encryptedData = $encrypt(json_encode($requestData), $key, $iv);

    // Get the app_key and verify token
    $appKey = md5($appName);
    $verify = $getVerify($encryptedData, $appName, $key);

    // Base64 encode the payload
    $payload = base64_encode(json_encode(['app_key' => $appKey, 'verify' => $verify,
        'encrypt_data' => $encryptedData]));

    // Choose the URL based on the $useSecondUrl flag
    $url = $useSecondUrl ? $urls[1] : $urls[0];

    // Define additional parameters to be sent in the request body
    $bodyParams = ['data' => $payload, 'appid' => '27', 'platform' => 'android',
        'version' => '129', 'medium' => 'Website', ];

    // Initialize cURL session
    $ch = curl_init($url);

    // Set cURL options
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($bodyParams));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Platform: android',
        'Content-Type: application/x-www-form-urlencoded', ]);
    curl_setopt($ch, CURLOPT_REFERER, 'https://movie-web.app');
    // Execute cURL session and get the response
    $timeoutSeconds = $timeOut; // Adjust this value as needed
    curl_setopt($ch, CURLOPT_TIMEOUT, $timeoutSeconds);
    // Set a timeout for the connection phase (in seconds)
    $connectTimeoutSeconds = $timeOut; // Adjust this value as needed
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $connectTimeoutSeconds);
    $response = curl_exec($ch);

    // Check for cURL errors and handle them
    if (curl_errno($ch)) {
        $errorMessage = 'cURL Error: ' . curl_error($ch);
        if ($GLOBALS['DEBUG']) {
            echo $errorMessage . "<br>";
        }
        throw new Exception($errorMessage);
    }

    // Close cURL session
    curl_close($ch);

    // Check for response errors and handle them
    if (!$response) {
        $errorMessage = 'HTTP Error: Failed to fetch movie source data.';
        if ($GLOBALS['DEBUG']) {
            echo $errorMessage . "<br>";
        }
        throw new Exception($errorMessage);
    }

    // Return the response
    return json_decode($response, true);
}

function tvembed_cc($movieId, $imdbId, $title)
{
    global $timeOut, $maxResolution, $type, $seasonNoPad, $episodeNoPad;

    $tSite = 'tvembed_cc';
	
	if ($GLOBALS['DEBUG']) {
        echo 'Started running tvembed_cc </br></br>';
    }	
	
	$apiUrl  = 'https://tvembed.cc';
	
	if ($type == 'movies'){
		$searchQuery = '/movie/' . $movieId;
	} else {
		$searchQuery = '/tv/' . $movieId . '/' . $seasonNoPad . '/' . $episodeNoPad;
	}

	$apiUrl = $apiUrl . $searchQuery;	
	
	try {
		
				$contextOptions = [
			'http' => [
				'method' => "GET",
				'header' => "Accept-Language: en-US,en;q=0.5\r\n" .	
							"Accept: application/json, text/javascript, */*; q=0.01\r\n" .
							"X-Requested-With: XMLHttpRequest\r\n" .							
							"User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/119.0\r\n" .
							"Referer: $apiUrl\r\n",
				'timeout' => $timeOut,
			]
		];		
				
		$context = stream_context_create($contextOptions);
		$response = @file_get_contents($apiUrl, false, $context);
		
		if ($response === false) {
            throw new Exception('HTTP Error: tvembed_cc');
		}				

		if(!preg_match_all('#(?<=,url:\").*?(?=\")#', $response, $urlMatches)){	
		 
			throw new Exception("No links found on tvembed_cc.");		
			
		 }		
		 
		$firstSourceUrl = null;

		foreach ($urlMatches[0] as $urlMatch) {
			
			if (isset($urlMatch) && !empty($urlMatch)) {
				$firstSourceUrl = $urlMatch;
				if ($GLOBALS['DEBUG']) {
					echo "Compressed url found: " . $firstSourceUrl . "<br><br>";
				}
				break;
			}
		}
		
		if(!$firstSourceUrl){
			throw new Exception("No links found on tvembed_cc.");
		}	
		
	    $ch = curl_init();
		
		$url = 'https://script.google.com/macros/s/AKfycbyBjcxEnbp3JHBkJzlBYt3w0ZcSXLPdc7RFdWg3mqhuFgTi6dmapMfgYGtaoMGuJtzeVg/exec?data='.urlencode(decode_unicode_sequence($firstSourceUrl));	

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

        $response = curl_exec($ch);
		
		if ($response === false) {
            throw new Exception("Curl error: " . curl_error($ch));
        }
		
		if($response){
			$firstSourceUrl = $response;
			
			if ($GLOBALS['DEBUG']) {
				echo "Video link: " . $firstSourceUrl . "<br><br>";
			}
		} else {
			throw new Exception("Decompression failed on tvembed_cc.");
		}
		
		logDetails('tvembed_cc', 'none', 'successful', $GLOBALS['logTitle'], isset($apiUrl) ? $apiUrl : 'n/a', $firstSourceUrl, $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');	
	
		
        return $firstSourceUrl;
  
    } catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running tvembed_cc </br></br>';
        }
		
			logDetails('tvembed_cc', 'none', 'failed', $GLOBALS['logTitle'], isset($apiUrl) ? $apiUrl : 'n/a', 'n/a', $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');

        return false;
    }
}

function blackvid_space($movieId, $title)
{
    global $timeOut, $movieId, $type, $maxResolution, $seasonNoPad, $episodeNoPad;

    if ($GLOBALS['DEBUG']) {
        echo 'Started running blackvid_space </br></br>';
    }	
	
	if($type == 'series'){
		$url = "https://prod.api.blackvid.space/v3/tv/sources/" . $movieId;
		$url .= '/' . $seasonNoPad  . '/' . $episodeNoPad;
	} else {
		$url = "https://prod.api.blackvid.space/v3/movie/sources/" . $movieId;
	}		
	
	$url .= '?key=b6055c533c19131a638c3d2299d525d5ec08a814';
    
    $options = ['http' => ['method' => "GET", 'header' =>
        "Content-Type: application/json"]];

    try {
        $context = stream_context_create(['http' => ['timeout' => $timeOut]]);
        $response = @file_get_contents($url, false, $context);
		
        if ($response === false) {
            throw new Exception('HTTP Error: blackvid_space</br></br>');
        }
    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Failed to fetch movie source data from blackvid_space Error: ' . $error->
                getMessage() . "</br></br>";
            echo 'Finished running blackvid_space </br></br>';

        }
			logDetails('blackvid_space', 'none', 'failed', $GLOBALS['logTitle'], $url, 'n/a', $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');					

        return false;
    }

    $statusCode = http_response_code();
	
    if ($statusCode !== 200) {
        if ($GLOBALS['DEBUG']) {
            echo "Failed to fetch movie source data from blackvid_space Response code: " .
                $statusCode . "<br></br>";
            echo 'Finished running blackvid_space </br></br>';
        }
			logDetails('blackvid_space', 'none', 'failed', $GLOBALS['logTitle'], $url, 'n/a', $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');
        return false;
    }
	
	$decryptedJson = decryptAesGCM($response, '2378f8e4e844f2dc839ab48f66e00acc2305a401');
    $data = json_decode($decryptedJson, true);
	
	 if ($GLOBALS['DEBUG']) {
		echo 'The Decrypted Json Response: </br>';
		print_r($decryptedJson);
		echo '</br></br>';
	}

	if ($data && isset($data['sources'])) {
		$bestLowerResolutionUrl = null;

		foreach ($data['sources'] as $source) {
			foreach ($source['sources'] as $videoSource) {
				$quality = preg_replace('/4k/i', '2160', $videoSource['quality']);
				$vurl = $videoSource['url'];
				
				if (strtolower($quality ) === 'auto') {
					$quality  = '720';
				}
				
				$quality = intval($quality );
				
				if ($quality === $maxResolution) {
					if ($GLOBALS['DEBUG']) {
						echo 'Video Link: ' . $vurl . "</br></br>";
					}
					logDetails('blackvid_space', 'none', 'successful', $GLOBALS['logTitle'], $url, $vurl, $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');						
										
					return $vurl;
				} elseif (intval($quality) < intval($maxResolution) && !$bestLowerResolutionUrl) {
					$bestLowerResolutionUrl = $vurl;
				}
			}
		}

		if ($bestLowerResolutionUrl) {
			if ($GLOBALS['DEBUG']) {
				echo 'Video Link: ' . $bestLowerResolutionUrl . "</br></br>";
			}
			logDetails('blackvid_space', 'none', 'successful', $GLOBALS['logTitle'], $url, $vurl, $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');					
			return $bestLowerResolutionUrl;
		} else {
			if ($GLOBALS['DEBUG']) {
				echo "No suitable URL found. </br></br>";
			}
			echo 'Finished running blackvid_space </br></br>';
			logDetails('blackvid_space', 'none', 'failed', $GLOBALS['logTitle'], $url, 'n/a', $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');			
			return false;
		}
	} else {

        if ($GLOBALS['DEBUG']) {
            echo "No sources found in the JSON data.";
        }
        echo 'Finished running blackvid_space </br></br>';
			logDetails('blackvid_space', 'none', 'failed', $GLOBALS['logTitle'], $url, 'n/a', $type, $GLOBALS['movieId'], $type === 'series' ? $GLOBALS['seriesCode'] : 'n/a');		
        return false;
    }
}

////////////////////////////// Torrents Movies & Tv Shows Websites ///////////////////////////////

function initialize_thepiratebay_org($movieId, $imdbId, $title, $year, $tvpack=false)
{
    global $timeOut, $maxResolution, $torrentData, $type, $season, $episode, $seasonNoPad;
    $tSite = 'thepiratebay_org';

    if ($GLOBALS['DEBUG']) {
        echo 'Started running thepiratebay_org </br></br>';
    }
	
    $base_url = "https://apibay.org";
  
    if ($type == 'movies') {
        $apiUrl = $base_url . '/q.php?q=' . urlencode($title . ' ' . $year) . '&cat=207,202,201';
    } else {
        $apiUrl = $base_url . '/q.php?q=' . urlencode($title) . '&cat=208,205';
    }

    return $apiUrl;
}

function thepiratebay_org($response, $tvpack=false)
{
    global $timeOut, $maxResolution, $torrentData, $language, $languageMapping, $type, $season, $episode;

    $tSite = 'thepiratebay_org';


try {

    if ($response === false) {
        throw new Exception('HTTP Error: thepiratebay');
    }

}
catch (exception $error) {
    if ($GLOBALS['DEBUG']) {
        echo 'Error: ' . $error->getMessage() . "</br></br>";
    }

    return false;
}

$data = json_decode($response, true);

try {		
	
	$totalAdded = 0;
    foreach ($data as $torrent) {
		
		$extractedTitle = $torrent['name'];
        $matchedRes = $torrent['name'];
        $matchedHash = $torrent['info_hash'];
		
        
        preg_match('/(2160|1080|720|480|360|240)[pP]/i', $matchedRes, $resolution);
		
		// If resolution wasn't found, set it to 480p
		if (!$resolution) {
			$resolution[0] = '480p';
		}

        if (isset($resolution[0])) {
/*             if ($GLOBALS['DEBUG']) {
                echo "matchedRes: " . $resolution[0] . "</br></br>";
                echo "matchedHash: " . $matchedHash . "</br></br>";
            } */
			if ($tvpack) {           
				$title = preg_replace('/s\d{2}e\d{2}/i', 'Season ' . $GLOBALS['seasonNoPad'], $GLOBALS['globalTitle']);
			} else {
				$title = $GLOBALS['globalTitle'];
			}
			if(filterCompareTitles($extractedTitle, $title, $tvpack)){			
				$torrentData[] = [
					'title_long' => $title, 
					'hash' => $matchedHash, 
					'quality' => $resolution[0],
					'extracted_title' => $extractedTitle,				
					'tvpack' => $tvpack
				];	
						
				$totalAdded++;
			}
        }
    }
	if ($GLOBALS['DEBUG']) {
		echo 'Finished running thepiratebay_org (' .  $totalAdded . ') </br></br>';
	}	
    return $totalAdded;;
}
catch (exception $error) {
    if ($GLOBALS['DEBUG']) {
        echo 'Error: ' . $error->getMessage() . "</br></br>";
    }

    return false;
}



}

function initialize_popcornTime($movieId, $imdbId, $title, $tvpack=false)
{
    global $timeOut, $maxResolution, $torrentData, $type, $season, $episode;
    $tSite = 'popcornTime';

    if ($GLOBALS['DEBUG']) {
        echo 'Started running popcornTime </br></br>';
    }

	 if ($type == 'movies'){
		$apiUrl = 'https://shows.cf/movie/' . $imdbId;		
	 } else {
		$apiUrl = 'https://shows.cf/show/' . $imdbId;
	 }

	 return $apiUrl;
}	 

function popcornTime($response, $tvpack=false)
{
    global $timeOut, $maxResolution, $torrentData, $type, $season, $episode;
    $tSite = 'popcornTime';

    try {

        if ($response === false) {
            throw new Exception('HTTP Error: popcornTime');
        }

        $data = json_decode($response, true);
		

		if ($type == 'series'){
		//Run for series.
		if (!isset($data['episodes']) || !is_array($data['episodes'])) {			
			return false;
		}
		
		$filtered = array_filter($data['episodes'], function ($ep) use ($season, $episode) {
			$hasAllKeys = isset($ep['season'], $ep['episode'], $ep['torrents']);
			return $hasAllKeys && $ep['season'] == $season && $ep['episode'] == $episode;
		});
		
		if (empty($filtered) || !isset(current($filtered)['torrents'])) {
			return false;
		}	

		} else {

		//Run for movies.
        if (!isset($data['torrents'])) {
            throw new Exception('Data does not meet criteria');
        }

/*         if ($GLOBALS['DEBUG']) {
            echo 'The Json Response: ' . print_r($response) . '</br></br>';
        } */
        		
		if (isset($data['torrents']['en'])) {
			$torrents = $data['torrents']['en'];
			
		} else {
			
		if ($GLOBALS['DEBUG']) {
            echo 'Couldn\'t locate any torrents on popcornTime. </br></br>';
        }

		return false;
		}
		}
		if ($tvpack) {           
			$title = preg_replace('/s\d{2}e\d{2}/i', 'Season ' . $GLOBALS['seasonNoPad'], $GLOBALS['globalTitle']);
		} else {
			$title = $GLOBALS['globalTitle'];
		}

        $totalAdded = 0;
		if (isset($torrents) && is_array($torrents) && !empty($torrents)) {
			foreach ($torrents as $resolutionKey => $torrentInfo) {
				
				$extractedTitle = $torrentInfo['title'];				
				preg_match('/(?<=urn:btih:)([A-F|a-z\d]{40})/', $torrentInfo['url'], $matchedHash);				

				if (isset($matchedHash[0]) && isset($extractedTitle)) {
					if(filterCompareTitles($extractedTitle, $title, $tvpack)){
						$torrentData[] = [
							'title_long' => $title,
							'hash' => $matchedHash[0],
							'quality' => $resolutionKey,
							'extracted_title' => $extractedTitle,								
							'tvpack' => $tvpack
						];
						$totalAdded++;
					}
				}
			}
		} else {
			throw new Exception('Data does not meet criteria');
		}
/*      if ($GLOBALS['DEBUG']) {
            echo 'Torrents: ' . json_encode($torrentData) . "</br></br>";
        }*/
		
        if ($GLOBALS['DEBUG']) {
            echo 'Finished running popcornTime (' .  $totalAdded . ') </br></br>';
        }
        return $totalAdded;

    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running popcornTime </br></br>';
        }
	
        return false;
    }
}

function initialize_torrentGalaxy_to($movieId, $imdbId, $title, $tvpack=false)
{
    global $timeOut, $maxResolution, $torrentData, $language, $languageMapping, $type, $season, $seasonNoPad, $episode;

    $tSite = 'Torrent Galaxy';
	
	if ($GLOBALS['DEBUG']) {
        echo 'Started running torrentGalaxy_to </br></br>';
    }
	
    $key = $movieId . '_torrentGalaxy_to';
	if ($type == 'movies'){
		$searchQuery = $imdbId;
	} else {

		$searchQuery = preg_replace('/[^a-zA-Z0-9 ]/', '', $title);
	}
	
    $siteLanguage = $languageMapping['TorrentGalaxy'][$language] ?? null;	

	$apiUrl = 'https://torrentgalaxy.to/torrents.php?search=' . urlencode($searchQuery) . '&nox=2';	

	if ($siteLanguage !== null) {
		$apiUrl .= '&lang=' . $siteLanguage;
	}	
	if ($tvpack) {
		$apiUrl .= '&c6=1';
	}
	return $apiUrl;
}	

function torrentGalaxy_to($response, $tvpack=false)
{
    global $timeOut, $maxResolution, $torrentData, $language, $languageMapping, $type, $season, $episode;

    $tSite = 'Torrent Galaxy';	

    try {

        if ($response === false) {
            throw new Exception('HTTP Error: torrentGalaxy_to');
        }


    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
        }

        return false;
    }

    $data = $response;
	

    try {
        // Perform pattern matching to extract torrent data
        preg_match_all('/(?<=tgxtablerow)[\s\S]*?(?=<\/table>)/', $data, $matches);

        if (count($matches[0]) === 0) {
            throw new Exception("No links found on torrentGalaxy_to."); // Throw a custom exception
        }

		$totalAdded = 0;
        // Loop through the 'matches' array
        for ($i = 0; $i < count($matches[0]); $i++) {

            // Extracted data from 'matches'
            $extractedData = $matches[0][$i];

			// Replace '4K' or '4k' with '2160p' before extracting the resolution
			$extractedData = str_ireplace("4K", "2160p", $extractedData);

            // Apply the regex patterns to extract 'matchedRes' and 'matchedHash'
            preg_match('/(2160|1080|720|480|360|240)[pP]/i', $extractedData, $matchedRes);
            preg_match('/(?<=urn:btih:)([A-F|a-z\d]{40})/', $extractedData, $matchedHash);
			if(preg_match_all('/(?<=title=").*?(?=")/', $extractedData, $matchedTitle)){
				$extractedTitle = html_entity_decode($matchedTitle[0][0]);
			} else {
				 continue;
			}	
			
			// If matchedRes wasn't found, set it to 480p
			if (!$matchedRes) {
				$matchedRes[0] = '480p';
			}
			
            // Check if both 'matchedRes' and 'matchedHash' were found
            if ($matchedRes && $matchedRes[0] && $matchedHash && $matchedHash[0]){
/*                 if ($GLOBALS['DEBUG']) {
                    echo "matchedRes: " . $matchedRes[0] . "</br></br>";
                    echo "matchedHash: " . $matchedHash[0] . "</br></br>";
                } */
				if ($tvpack) {           
					$title = preg_replace('/s\d{2}e\d{2}/i', 'Season ' . $GLOBALS['seasonNoPad'], $GLOBALS['globalTitle']);
				} else {
					$title = $GLOBALS['globalTitle'];
				}
				if(filterCompareTitles($extractedTitle, $title, $tvpack)){				
					$torrentData[] = [
						'title_long' => $title, 
						'hash' => $matchedHash[0], 
						'quality' => $matchedRes[0],
						'extracted_title' => $extractedTitle,						
						'tvpack' => $tvpack
					];	
					$totalAdded++;
				}
            }
        }
	    if ($GLOBALS['DEBUG']) {
            echo 'Finished running torrentGalaxy_to (' .  $totalAdded . ') </br></br>';
        }

        return $totalAdded;
    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running torrentGalaxy_to </br></br>';
        }

        return false;
    }
}

function initialize_glodls_to($movieId, $imdbId, $title, $year, $tvpack=false)
{
    global $timeOut, $maxResolution, $torrentData, $language, $languageMapping, $type, $season, $seasonNoPad, $episode;

    $tSite = 'glodls_to';
	
	if($type == "movies"){
		$searchQuery = preg_replace('/[^a-zA-Z0-9 ]/', '', $title . ' ' . $year);
	} else {

		$searchQuery = preg_replace('/[^a-zA-Z0-9 ]/', '', $title);	
	}

	if ($GLOBALS['DEBUG']) {
        echo 'Started running glodls_to </br></br>';
    }
	
    $key = $movieId . '_glodls_to';
	
    $siteLanguage = $languageMapping['Glodls'][$language] ?? null;	

	$apiUrl = 'https://glodls.to/search_results.php?search=' . urlencode($searchQuery) . '&incldead=0&inclexternal=0&sort=id&order=desc';	
	

	if ($siteLanguage !== null) {
		$apiUrl .= '&lang=' . $siteLanguage;
	}
	if ($type == 'series') {
			
		$apiUrl .= '&cat=41';
	} elseif ($type == 'movies') {
			
		$apiUrl .= '&c52=1';
	}
	
	return $apiUrl;
}	

function glodls_to($response, $tvpack=false)
{
    global $timeOut, $maxResolution, $torrentData, $language, $languageMapping, $type, $season, $seasonNoPad, $episode;

    $tSite = 'glodls_to';	

    $data = $response;

    try {
        // Perform pattern matching to extract torrent data
        preg_match_all('/(?<=ttable_col1)[\s\S]*?(?=<\/tr>)/', $data, $matches);

        if (count($matches[0]) === 0) {
            throw new Exception("No links found on glodls_to."); // Throw a custom exception
        }
		$totalAdded = 0;
         // Loop through the 'matches' array
        for ($i = 0; $i < count($matches[0]); $i++) {
			
			// Extracted data from 'matches'
            $extractedData = $matches[0][$i];				
			
			// Replace '4K' or '4k' with '2160p' before extracting the resolution
			$extractedData = str_ireplace("4K", "2160p", $extractedData);

            // Apply the regex patterns to extract 'matchedRes' and 'matchedHash'
            preg_match('/(2160|1080|720|480|360|240)[pP]/i', $extractedData, $matchedRes);
            preg_match('/(?<=urn:btih:)([A-F|a-z\d]{40})/', $extractedData, $matchedHash);
			if(preg_match_all('/(?<=title=").*?(?=")/', $extractedData, $matchedTitle)){
				$extractedTitle = html_entity_decode($matchedTitle[0][0]);
				
			} else {
				 continue;
			}	
			
			// If matchedRes wasn't found, set it to 480p
			if ($tvpack) {
				$matchedRes[0] = 'unknown';
			} else if (!$matchedRes) {
				$matchedRes[0] = '480p';
			}
			
            // Check if both 'matchedRes' and 'matchedHash' were found
            if (($matchedRes && $matchedRes[0] && $matchedHash && $matchedHash[0]) || ($tvpack === true && $matchedHash[0])){
/*                 if ($GLOBALS['DEBUG']) {
                    echo "matchedRes: " . $matchedRes[0] . "</br></br>";
                    echo "matchedHash: " . $matchedHash[0] . "</br></br>";
                } */
				if ($tvpack) {           
					$title = preg_replace('/s\d{2}e\d{2}/i', 'Season ' . $GLOBALS['seasonNoPad'], $GLOBALS['globalTitle']);
				} else {
					$title = $GLOBALS['globalTitle'];
				}
				if(filterCompareTitles($extractedTitle, $title, $tvpack)){
					
					$torrentData[] = [
						'title_long' => $title, 
						'hash' => $matchedHash[0], 
						'quality' => $matchedRes[0],
						'extracted_title' => $extractedTitle,						
						'tvpack' => $tvpack
					];				
					$totalAdded++;
				}
            }
        }

		if ($GLOBALS['DEBUG']) {
			echo 'Finished running glodls_to (' .  $totalAdded . ') </br></br>';
		}

        return $totalAdded;
    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running glodls_to </br></br>';
        }

        return false;
    }
}

function initialize_MagnetDL_com($movieId, $imdbId, $title, $year, $tvpack=false)
{	
    global $timeOut, $maxResolution, $torrentData, $language, $languageMapping, $type, $season, $seasonNoPad, $episode;

    $tSite = 'magnetdl_com';
	
	if ($GLOBALS['DEBUG']) {
        echo 'Started running magnetdl_com </br></br>';
    }
	
    $key = $movieId . '_magnetdl_com';
	
	$titleNoPeriods = $title;
	$titleNoPeriods = str_replace('.', ' ', $titleNoPeriods);
	if($type == "movies"){
		$searchQuery = $title . ' (' . $year . ')';
	} else {
		$searchQuery = $title;
	}
	
	$apiUrl = 'https://www.magnetdl.com/search/?q=' . urlencode($searchQuery);	

	if ($type == 'series') {
			
		$apiUrl .= '&m=1&x=35&y=17';
	} elseif ($type == 'movies') {
			
		$apiUrl .= '&m=1&x=38&y=19';
	}
	
	return $apiUrl;
}	

function magnetdl_com($response, $tvpack=false)
{
    global $timeOut, $maxResolution, $torrentData, $language, $languageMapping, $type, $season, $seasonNoPad, $episode;

    $tSite = 'magnetdl_com';	
	
    try {

        if ($response === false) {
            throw new Exception('HTTP Error: magnetdl_com');
        }


    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
        }

        return false;
    }

	$data = $response;
    try {
        // Perform pattern matching to extract torrent data
        preg_match_all('/(?<=class="m")[\s\S]*?(?=<\/tr>)/', $data, $matches);

        if (count($matches[0]) === 0) {
            throw new Exception("No links found on magnetdl_com."); // Throw a custom exception
        }
		$totalAdded = 0;
        // Loop through the 'matches' array
        for ($i = 0; $i < count($matches[0]); $i++) {

            // Extracted data from 'matches'
            $extractedData = $matches[0][$i];
			
			// Replace '4K' or '4k' with '2160p' before extracting the resolution
			$extractedData = str_ireplace("4K", "2160p", $extractedData);

            // Apply the regex patterns to extract 'matchedRes' and 'matchedHash'
			preg_match('/(2160|1080|720|480|360|240)[pP]/i', $extractedData, $matchedRes);
            preg_match('/(?<=urn:btih:)([A-F|a-z\d]{40})/', $extractedData, $matchedHash); 
			preg_match_all('/(?<=title=").*?(?=">)/', $extractedData, $matchedTitle); 			
			
			// If matchedRes wasn't found, set it to 480p
			if (!$matchedRes) {
				$matchedRes[0] = '480p';
			}		
			
            // Check if both 'matchedRes' and 'matchedHash' were found
            if ($matchedRes && $matchedRes[0] && $matchedHash && $matchedHash[0] && $matchedTitle[0][1]){
				$extractedTitle = html_entity_decode($matchedTitle[0][1]);
				
/*                 if ($GLOBALS['DEBUG']) {
                    echo "matchedRes: " . $matchedRes[0] . "</br></br>";
                    echo "matchedHash: " . $matchedHash[0] . "</br></br>";
                } */
                
				if ($tvpack) {           
					$title = preg_replace('/s\d{2}e\d{2}/i', 'Season ' . $GLOBALS['seasonNoPad'], $GLOBALS['globalTitle']);
				} else {
					$title = $GLOBALS['globalTitle'];
				}	

				if(filterCompareTitles($extractedTitle, $title, $tvpack)){
					$torrentData[] = [
						'title_long' => $title, 
						'hash' => $matchedHash[0], 
						'quality' => $matchedRes[0],
						'extracted_title' => $extractedTitle,			
						'tvpack' => $tvpack
					];
					
					$totalAdded++;
				}
            }
        }			

		if ($GLOBALS['DEBUG']) {
			echo 'Finished running magnetdl_com (' .  $totalAdded . ') </br></br>';
		}
        return $totalAdded;
    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running magnetdl_com </br></br>';
        }

        return false;
    }
}

function initialize_torrentDownload_info($movieId, $imdbId, $title, $year, $tvpack=false)
{
    global $timeOut, $maxResolution, $torrentData, $language, $languageMapping, $type, $season, $seasonNoPad, $episode;

    $tSite = 'torrentDownload_info';
	
	if ($GLOBALS['DEBUG']) {
        echo 'Started running torrentDownload_info </br></br>';
    }
	
    $key = $movieId . '_torrentDownload_info';
	
	if($type == "movies"){
		$searchQuery = preg_replace('/[^a-zA-Z0-9 ]/', '', $title . ' ' . $year);
	} else {

		$searchQuery = preg_replace('/[^a-zA-Z0-9 ]/', '', $title);
	}

	$apiUrl = 'https://www.torrentdownload.info/search?q=' . urlencode($searchQuery);	
	
	return $apiUrl;
}

function torrentDownload_info($response, $tvpack=false)
{
    global $timeOut, $maxResolution, $torrentData, $language, $languageMapping, $type, $season, $episode;

    $tSite = 'torrentDownload_info';
	
    try {

        if ($response === false) {
            throw new Exception('HTTP Error: torrentDownload_info');
        }


    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
        }

        return false;
    }

    $data = $response;
	

    try {
        // Perform pattern matching to extract torrent data
        preg_match_all('/(?<=<td class="tdleft">)[\s\S]*?(?=<\/tr>)/', $data, $matches);

        if (count($matches[0]) === 0) {
            throw new Exception("No links found on torrentDownload_info."); // Throw a custom exception
        }

		$totalAdded = 0;
        // Loop through the 'matches' array
        for ($i = 3; $i < count($matches[0]); $i++) {

            // Extracted data from 'matches'
            $extractedData = $matches[0][$i];
			
			// Replace '4K' or '4k' with '2160p' before extracting the resolution
			$extractedData = str_ireplace("4K", "2160p", $extractedData);

            // Apply the regex patterns to extract 'matchedRes' and 'matchedHash'
            preg_match('/(2160|1080|720|480|360|240)[pP]/i', $extractedData, $matchedRes);
            preg_match('/(?<="\/)([A-F|a-z\d]{40})(?=\/)/', $extractedData, $matchedHash);
			$extractedTitle = strip_tags($extractedData);
			$extractedTitle = html_entity_decode($extractedTitle);
			$extractedTitle = preg_replace('/\s».*$/', '', $extractedTitle);

			
			// If matchedRes wasn't found, set it to 480p
			if (!$matchedRes) {
				$matchedRes[0] = '480p';
			}	
			
            // Check if both 'matchedRes' and 'matchedHash' were found
            if ($matchedRes && $matchedRes[0] && $matchedHash && $matchedHash[0] && $extractedTitle){
/*                 if ($GLOBALS['DEBUG']) {
                    echo "matchedRes: " . $matchedRes[0] . "</br></br>";
                    echo "matchedHash: " . $matchedHash[0] . "</br></br>";
                } */
				if ($tvpack) {           
					$title = preg_replace('/s\d{2}e\d{2}/i', 'Season ' . $GLOBALS['seasonNoPad'], $GLOBALS['globalTitle']);
				} else {
					$title = $GLOBALS['globalTitle'];
				}	
				if(filterCompareTitles($extractedTitle, $title, $tvpack)){	
					$torrentData[] = [
						'title_long' => $title, 
						'hash' => $matchedHash[0], 
						'quality' => $matchedRes[0],
						'extracted_title' => $extractedTitle,						
						'tvpack' => $tvpack
					];				
					$totalAdded++;
				}
            }
        }
		if ($GLOBALS['DEBUG']) {
			echo 'Finished running torrentDownload_info (' .  $totalAdded . ') </br></br>';
		}	
        return $totalAdded;
    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running torrentDownload_info </br></br>';
        }

        return false;
    }
}

function initialize_bitLordSearch_com($movieId, $imdbId, $title, $year, $tvpack=false)
{
	global $timeOut, $maxResolution, $torrentData, $type, $season, $seasonNoPad, $episode;
	$tSite = 'bitLordSearch_com';

	if ($GLOBALS['DEBUG']) {
		echo 'Started running bitLordSearch_com </br></br>';
	}

	 $apiUrl = "https://bitlordsearch.com/search";
	 if ($type == 'movies'){
		$apiUrl .= '?q='.urlencode($title . ' (' . $year . ')').'&offset=0&limit=50&filters[field]=seeds&filters[sort]=desc&filters[time]=0&filters[category]=3&filters[adult]=false&filters[risky]=false';		
	 } else {
		$apiUrl .= '?q='.urlencode($title).'&offset=0&limit=50&filters[field]=seeds&filters[sort]=desc&filters[time]=0&filters[category]=4&filters[adult]=false&filters[risky]=false';
	 }
	 
	 return $apiUrl;		 
}		 

function bitLordSearch_com($response, $tvpack=false)
{
    global $timeOut, $maxResolution, $torrentData, $type, $season, $episode;
    $tSite = 'bitLordSearch_com';

    try {		
		
		if ($response === false) {
            throw new Exception('HTTP Error: bitLordSearch');
        }
		
	} catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
        }

        return false;
    }
		
    $data = $response;
	

    try {
        // Perform pattern matching to extract torrent data
        preg_match_all('/(?<=<tr class="bls-row")[\s\S]*?(?=<\/tr>)/', $data, $matches);

        if (count($matches[0]) === 0) {
            throw new Exception("No links found on bitLordSearch_com."); // Throw a custom exception
        }

		$totalAdded = 0;
        // Loop through the 'matches' array
        for ($i = 0; $i < count($matches[0]); $i++) {

            // Extracted data from 'matches'
            $extractedData = $matches[0][$i];

			// Replace '4K' or '4k' with '2160p' before extracting the resolution
			$extractedData = str_ireplace("4K", "2160p", $extractedData);
			
            // Apply the regex patterns to extract 'matchedRes' and 'matchedHash'
            preg_match('/(2160|1080|720|480|360|240)[pP]/i', $extractedData, $matchedRes);
            preg_match('/(?<=urn:btih:)([A-F|a-z\d]{40})/', $extractedData, $matchedHash);
			if(preg_match_all('/(?<="title">).*?(?=<)/', $extractedData, $matchedTitle)){
				$extractedTitle = html_entity_decode($matchedTitle[0][0]);
			} else {
				 continue;
			}
			
			// If matchedRes wasn't found, set it to 480p
			if (!$matchedRes) {
				$matchedRes[0] = '480p';
			}
			
            // Check if both 'matchedRes' and 'matchedHash' were found
            if ($matchedRes && $matchedRes[0] && $matchedHash && $matchedHash[0]){
/*                 if ($GLOBALS['DEBUG']) {
                    echo "matchedRes: " . $matchedRes[0] . "</br></br>";
                    echo "matchedHash: " . $matchedHash[0] . "</br></br>";
                } */				
				if ($tvpack) {           
					$title = preg_replace('/s\d{2}e\d{2}/i', 'Season ' . $GLOBALS['seasonNoPad'], $GLOBALS['globalTitle']);
				} else {
					$title = $GLOBALS['globalTitle'];
				}	
				if(filterCompareTitles($extractedTitle, $title, $tvpack)){				
					$torrentData[] = [
						'title_long' => $title, 
						'hash' => $matchedHash[0], 
						'quality' => $matchedRes[0],
						'extracted_title' => $extractedTitle,						
						'tvpack' => $tvpack
					];	
					$totalAdded++;
				}
            }
        }
		if ($GLOBALS['DEBUG']) {
            echo 'Finished running bitLordSearch_com (' .  $totalAdded . ') </br></br>';
        }
        return $totalAdded;
    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
			echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running bitLordSearch_com </br></br>';
        }
        return false;
    }		
}

function initialize_ezTV_re($movieId, $imdbId, $title, $tvpack=false)
{
    global $timeOut, $maxResolution, $torrentData, $language, $languageMapping, $type, $season, $seasonNoPad, $episode;

    $tSite = 'EZTV';
	
	if ($GLOBALS['DEBUG']) {
        echo 'Started running ezTV_re </br></br>';
    }
	
    $key = $movieId . '_ezTV_re';	
	
	$stripImdbId = str_replace("tt", "", $imdbId);
		
	$apiUrl = 'https://eztvx.to/api/get-torrents?imdb_id='.$stripImdbId.'&limit=100';

	return $apiUrl;

}

function ezTV_re($response, $tvpack=false)
{
    global $timeOut, $maxResolution, $torrentData, $type, $season, $episode;
    $tSite = 'ezTV_re';
    $totalAdded = 0;

    try {
        if ($response === false) {
            throw new Exception('HTTP Error: ezTV_re');
        }

        $data = json_decode($response, true);

        if (isset($data['torrents']) && is_array($data['torrents'])) {
			
			if(!$tvpack){
				$filtered = array_filter($data['torrents'], function ($torrent) use ($season, $episode) {
					return isset($torrent['season']) && $torrent['season'] == $season && isset($torrent['episode']) && $torrent['episode'] == $episode;
				});
			} else {
				$filtered = $data['torrents'];
			}	

            if (!empty($filtered)) {
                foreach ($filtered as $torrentInfo) {
                    $title = $GLOBALS['globalTitle'];

                    if ($tvpack) {
                        $title = preg_replace('/s\d{2}e\d{2}/i', 'Season ' . $GLOBALS['seasonNoPad'], $title);
                    }

                    $extractedTitle = $torrentInfo['title'];
                    preg_match('/(?<=urn:btih:)([A-Fa-f\d]{40})/', $torrentInfo['magnet_url'], $matchedHash);
                    preg_match('/(2160|1080|720|480|360|240)[pP]/i', $extractedTitle, $matchedRes);

                    if (!$matchedRes) {
                        $matchedRes[0] = '480p';
                    }

                    if (isset($matchedHash[0]) && isset($extractedTitle)) {
                        if (filterCompareTitles($extractedTitle, $title, $tvpack)) {
                            $torrentData[] = [
                                'title_long' => $title,
                                'hash' => $matchedHash[0],
                                'quality' => $matchedRes[0],
                                'extracted_title' => $extractedTitle,
                                'tvpack' => $tvpack
                            ];
                            $totalAdded++;
                        }
                    }
                }

            } else {
                throw new Exception('No matching torrents found');
            }
        } else {
            throw new Exception('Data does not meet criteria');
        }

        if ($GLOBALS['DEBUG']) {
            echo 'Finished running ezTV_re (' .  $totalAdded . ') </br></br>';
        }
        return $totalAdded;

    } catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running ezTV_re </br></br>';
        }
    
        return false;
    }
}

function initialize_yts_mx($movieId, $imdbId, $title)
{
    global $timeOut, $maxResolution, $torrentData;
    $tSite = 'Yts';

    if ($GLOBALS['DEBUG']) {
        echo 'Started running yts_mx </br></br>';
    }

    $apiUrl = 'https://yts.mx/api/v2/list_movies.json?query_term=' . $imdbId .
        '&sort_by=seeds&order_by=desc';
		
	return $apiUrl;
}

function yts_mx($response)
{
    global $timeOut, $maxResolution, $torrentData;
    $tSite = 'Yts';

    try {

        if ($response === false) {
            throw new Exception('HTTP Error: yts_mx');
        }

        $data = json_decode($response, true);

        if (!isset($data['status']) || $data['status'] !== 'ok' || !isset($data['data']) ||
            !isset($data['data']['movies']) || count($data['data']['movies']) === 0) {
            throw new Exception('Data does not meet criteria');
        }


    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Finished running yts_mx </br></br>';
            echo 'Error: ' . $error->getMessage() . "</br></br>";
        }
        return false;
    }


	try {
		$movie = $data['data']['movies'][0];
		$torrents = $movie['torrents'];
		$totalAdded = 0;
		// Loop through each torrent entry
		foreach ($torrents as $torrent) {
			if (!isset($torrent['hash'])) {
				// Skip this torrent if it doesn't have a hash
				continue;
			}
			
			$quality = $torrent['quality'] ?? '1080';
			
			$torrentData[] = [
				'title_long' => $GLOBALS['globalTitle'],
				'hash' => $torrent['hash'],
				'quality' => $quality, 
				'tvpack' => false
			];
			$totalAdded++;
		}
/* 		if ($GLOBALS['DEBUG']) {
			echo 'Torrents: ' . json_encode($torrentData) . "</br></br>";
		} */

        if ($GLOBALS['DEBUG']) {;
            echo 'Finished running yts_mx (' .  $totalAdded . ') </br></br>';
        }		        
        return $totalAdded;

    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running yts_mx </br></br>';
        }
        return false;
    }
}

////////////////////////////// Video Link Extractors ///////////////////////////////

function superEmbedVipExtract($url, $tSite, $referer)
{
    global $timeOut;

    if (strpos($url, '/player/') === false) {   
    $url = str_replace('/movie/', '/player/movie/', $url);
	}

    if ($GLOBALS['DEBUG']) {
        echo "Started superEmbedVipExtract for $tSite. </br></br>";
    }

    try {
		$DirectLink = null;
        $contextOptions = ['http' => ['timeout' => $timeOut, 'header' =>
            "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0\r\n" .
            "Referer: " . $referer]];

        $context = stream_context_create($contextOptions);
        $content = @file_get_contents($url, false, $context);
		
		if ($content === false) {
            throw new Exception('HTTP Error: superEmbedVipExtract');
        }
		
		if (preg_match('/(?<=decodeURIComponent\(escape\(r\)\))[\s\S]*?\)/', $content, $matches)) {
			
			$extractedString = $matches[0];
			
			if ($GLOBALS['DEBUG']) {
				echo 'Encrypted data extracted: ' . $extractedString . "</br></br>";
			}
			
			$extracted = str_getcsv($extractedString);
			

		if (preg_match('/\((.*)\)/', $extractedString, $matches)) {		


			$decryptedData = superEmbedDecodeString($extracted[0], $extracted[2], $extracted[1], $extracted[3], $extracted[4]);
			if (preg_match('/(?<=file:").*?(?=")/', $decryptedData, $matches)) {
				
				$DirectLink = $matches[0];

			} else {

				throw new Exception("Couldn't find the file link in superEmbedVipExtract for $tSite");
			}				
		
		} else {
			throw new Exception("Couldn't locate the encrypted host in superEmbedVipExtract for $tSite");
		}	   
		}

        if ($DirectLink) {

            $DirectLink = $matches[0];
			
			if ($GLOBALS['DEBUG']) {
                echo "Video link: " . $DirectLink . "<br><br>";
            }
			return $DirectLink;

        } else {
            throw new Exception("Couldn't extract the link in superEmbedVipExtract for $tSite");
        }

    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running superEmbedVipExtract. </br></br>';
        }
        return false;
    }
    if ($GLOBALS['DEBUG']) {
        echo 'Finished running superEmbedVipExtract. </br></br>';
    }
    return false;

}

function twoEmbedExtract($url, $tSite, $referer)
{
    global $timeOut;

    if (strpos($url, '/player/') === false) {   
    $url = str_replace('/movie/', '/player/movie/', $url);
	}

    if ($GLOBALS['DEBUG']) {
        echo "Started twoEmbedExtract for $tSite. </br></br>";
    }

    try {
        $contextOptions = ['http' => ['timeout' => $timeOut, 'header' =>
            "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0\r\n" .
            "Referer: " . $referer]];

        $context = stream_context_create($contextOptions);
        $response = @file_get_contents($url, false, $context);


        if ($response === false) {
            throw new Exception('HTTP Error: twoEmbedExtract');
        }

        if (preg_match('/(?<=file":").*?(?=","type")/', $response, $matches)) {

            $DirectLink = $matches[0];

			$DirectLink = str_replace('\\', '', $DirectLink);
			
			if ($GLOBALS['DEBUG']) {
                echo "Video link: " . $DirectLink . "<br><br>";
            }
			return $DirectLink;

        } else {
            throw new Exception('Couldn\'t extract the source links on twoEmbed');
        }

    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running twoEmbedExtract. </br></br>';
        }
        return false;
    }
    if ($GLOBALS['DEBUG']) {
        echo 'Finished running twoEmbedExtract. </br></br>';
    }
    return false;

}

function vidmolyExtract($url, $tSite, $referer)
{
	  global $timeOut;
	  
    try {
        $context = stream_context_create([
            'http' => [
                'timeout' => $timeOut,
                'header' => 
                    "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0\r\n" .
                    "Referer: " . $referer
            ]
        ]);

        $content = file_get_contents($url, false, $context);

        if ($content === false) {
            throw new Exception('HTTP Error: vidmolyExtract');
        }

        if (preg_match('/(?<=file:").*?(?=")/', $content, $matches)) {    
            $DirectLink = $matches[0];             

			$urlData = "|Origin='https://vidmoly.to/'|Referer='https://vidmoly.to/'|User-Agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0'";
			
			$checkData = $DirectLink . "|Referer='https://vidmoly.to/'|User-Agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0'";

            $lCheck = checkLinkStatusCode($checkData);
            if ($lCheck == true) {

				if ($GLOBALS['DEBUG']) {
					echo "Video link: " . $DirectLink . "<br><br>";
				}
                return 'hls_proxy.php?url=' . urlencode($DirectLink) . '&data=' . base64_encode($urlData);

            } else {
                return false;
            }
		}
    } catch (Exception $error) {
        if ($debug) {
            echo 'Error: ' . $error->getMessage() . "<br><br>";
        }
        return false;
    }
	return false;
}

function StreamwishExtract($url, $tSite, $referer)
{
    global $timeOut;

    try {
        $context = stream_context_create(['http' => ['timeout' => $timeOut, 'header' =>
            "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0\r\n" .
            "Referer: " . $referer, ], ]);

        $content = @file_get_contents($url, false, $context);


        if ($content === false) {
            throw new Exception('HTTP Error: StreamwishExtract');      
        }

       if (preg_match('/(?<=file:").*?(?=")/', $content, $matches)) {	

			$StreamwishDirect = $matches[0];				
		
			if ($GLOBALS['DEBUG']) {
				echo "Video link: " . $StreamwishDirect . "<br><br>";
			}				
								
			return $StreamwishDirect;
			
	
		} else {
			throw new Exception('Couldn\'t extract the source links on Streamwish');
		}

    } catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running StreamwishExtract. </br></br>';
        }
        return false;
    }
    if ($GLOBALS['DEBUG']) {
        echo 'Finished running StreamwishExtract. </br></br>';
    }
    return false;

}

function MixdropExtract($url, $tSite, $referer)
{
    global $timeOut;

    $url = str_replace('/f/', '/e/', $url);

    if ($GLOBALS['DEBUG']) {
        echo "Started MixdropExtract for $tSite. </br></br>";
    }

    try {
        $contextOptions = ['http' => ['timeout' => $timeOut, 'header' =>
            "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0\r\n" .
            "Referer: " . $referer]];

        $context = stream_context_create($contextOptions);
        $response = @file_get_contents($url, false, $context);


        if ($response === false) {
            throw new Exception('HTTP Error: MixdropExtract');
        }


        if (preg_match('#\beval\(function\(p,a,c,k,e,d\).*?\}\)\)#', $response, $matches)) {
            $unpacker = new JavaScriptUnpacker();

            // Use the methods of the JavaScriptUnpacker class as needed
            $unpackedCode = $unpacker->unpack($matches[0]);

        } else {
            throw new Exception('Couldn\'t find javscript code for MixdropExtract');
        }

        if (!empty($unpackedCode) && preg_match('/MDCore\.wurl="([^"]+)"/', $unpackedCode,
            $matches)) {

            $DirectLink = 'https:' . $matches[1];

            //Run link checker before returning.
            $urlData = $DirectLink . "|Referer='" . $referer .
                "'|User-Agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0'";

            $lCheck = checkLinkStatusCode($urlData);
            if ($lCheck == true) {

            if ($GLOBALS['DEBUG']) {
                echo "Video link: " . $DirectLink . "<br><br>";
            }
                return 'video_proxy.php?data=' . base64_encode($urlData);

            } else {
                return false;
            }

        } else {
            throw new Exception('Couldn\'t extract the source links on Mixdrop');
        }

    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running MixdropExtract. </br></br>';
        }
        return false;
    }
    if ($GLOBALS['DEBUG']) {
        echo 'Finished running MixdropExtract. </br></br>';
    }
    return false;

}

function StreamvidExtract($url, $tSite, $referer)
{
    global $timeOut;

    $unpacker = new JavaScriptUnpacker();
    if ($GLOBALS['DEBUG']) {
        echo "Started StreamvidExtract for $tSite. </br></br>";
    }

    try {
		
        $context = stream_context_create(['http' => ['timeout' => $timeOut, 'header' =>
            "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0\r\n" .
            "Referer: " . $referer, ], ]);

        $response = @file_get_contents($url, false, $context);


        if ($response === false) {
            throw new Exception('HTTP Error: StreamvidExtract');      
        }

        if (preg_match('#\beval\(function\(p,a,c,k,e,d\).*?\)\)\)#', $response, $matches)) {

            // Use the methods of the JavaScriptUnpacker class as needed
            $unpackedCode = $unpacker->unpack($matches[0]);	
			
			if (!empty($unpackedCode) && preg_match('/(?<=src:").*?(?=")/', $unpackedCode, $matches)){
				
				$StreamvidDirect = $matches[0];				
			
				if ($GLOBALS['DEBUG']) {
					echo "Video link: " . $StreamvidDirect . "<br><br>";
				}				
									
				return $StreamvidDirect;
				
			} else {
				throw new Exception('Couldn\'t extract the unpackedCode on Streamvid');
			}

		} else {
			throw new Exception('Couldn\'t extract the source links on Streamvid');
		}

    } catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running StreamvidExtract. </br></br>';
        }
        return false;
    }
    if ($GLOBALS['DEBUG']) {
        echo 'Finished running StreamvidExtract. </br></br>';
    }
    return false;

}

function FilelionsExtract($url, $tSite, $referer)
{
    global $timeOut;

    $unpacker = new JavaScriptUnpacker();
    if ($GLOBALS['DEBUG']) {
        echo "Started FilelionsExtract for $tSite. </br></br>";
    }

    try {
        $context = stream_context_create(['http' => ['timeout' => $timeOut, 'header' =>
            "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0\r\n" .
            "Referer: " . $referer, ], ]);

        $response = @file_get_contents($url, false, $context);


        if ($response === false) {
            throw new Exception('HTTP Error: FilelionsExtract');      
        }

        if (preg_match('#\beval\(function\(p,a,c,k,e,d\).*?\)\)\)#', $response, $matches)) {

            // Use the methods of the JavaScriptUnpacker class as needed
            $unpackedCode = $unpacker->unpack($matches[0]);		

			
			if (!empty($unpackedCode) && preg_match('/(?<=file:").*?(?=")/', $unpackedCode, $matches)){
				
				$filelionsDirect = $matches[0];				
			
				if ($GLOBALS['DEBUG']) {
					echo "Video link: " . $filelionsDirect . "<br><br>";
				}				
									
				return $filelionsDirect;
				
			} else {
				throw new Exception('Couldn\'t extract the unpackedCode on Filelions');
			}

		} else {
			throw new Exception('Couldn\'t extract the source links on Filelions');
		}

    } catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running FilelionsExtract. </br></br>';
        }
        return false;
    }
    if ($GLOBALS['DEBUG']) {
        echo 'Finished running FilelionsExtract. </br></br>';
    }
    return false;

}

function VoeExtract($url, $tSite, $referer)
{
    global $timeOut;

    if ($GLOBALS['DEBUG']) {
        echo "Started VoeExtract for $tSite. </br></br>";
    }

    try {
        $context = stream_context_create(['http' => ['timeout' => $timeOut, 'header' =>
            "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0\r\n" .
            "Referer: " . $referer, ], ]);

        $response = @file_get_contents($url, false, $context);


        if ($response === false) {
            throw new Exception('HTTP Error: VoeExtract');      
        }

        if (preg_match('/(?<=prompt\("Node", ").*?(?=")/', $response, $matches)) {		
			
			$DirectLink = $matches[0];				
		
			if ($GLOBALS['DEBUG']) {
				echo "Video link: " . $DirectLink . "<br><br>";
			}				
								
			return $DirectLink;			


		} else {
			throw new Exception('Couldn\'t extract the source links on Voe');
		}

    } catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running VoeExtract. </br></br>';
        }
        return false;
    }
    if ($GLOBALS['DEBUG']) {
        echo 'Finished running VoeExtract. </br></br>';
    }
    return false;

}

function UpstreamExtract($url, $tSite, $referer)
{
    global $timeOut;

    $unpacker = new JavaScriptUnpacker();
    if ($GLOBALS['DEBUG']) {
        echo "Started UpstreamExtract for $tSite. </br></br>";
    }

    try {
        $context = stream_context_create(['http' => ['timeout' => $timeOut, 'header' =>
            "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0\r\n" .
            "Referer: https://" . str_replace('_', '.', strtolower($tSite)), ], ]);

        $response = @file_get_contents($url, false, $context);


        if ($response === false) {
            throw new Exception('HTTP Error: UpstreamExtract');
            if ($GLOBALS['DEBUG']) {
                echo 'Error: ' . $error->getMessage() . "</br></br>";
            }
        }

        if (preg_match('#\beval\(function\(p,a,c,k,e,d\).*?\)\)\)#', $response, $matches)) {

            // Use the methods of the JavaScriptUnpacker class as needed
            $unpackedCode = $unpacker->unpack($matches[0]);			


		if (preg_match('#(?<=sources:\[{file:").*?upstream.*?(?="}])#', $unpackedCode, $matches)) {
			$sourceUrl = $matches[0];

			// Check if the URL starts with 'http' indicating it's a complete URL
			if (strpos($sourceUrl, 'http') !== 0) {  // It's not a full URL, so we will try to extract the domain
				if (preg_match('#image:"(https?://[^/]+)#', $unpackedCode, $imageMatches)) {
					$domain = $imageMatches[1];
					$sourceUrl = $domain . $sourceUrl;  // Append the relative URL to the domain to form the full URL
				} else {
					throw new Exception('Couldn\'t extract the domain from image URL on Upstream');
				}
			}

			if ($GLOBALS['DEBUG']) {
				echo "Video link: " . $sourceUrl . "<br><br>";
			}
			return $sourceUrl;

		} else {
			throw new Exception('Couldn\'t extract the source links on Upstream');
		}

    }
	}
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running UpstreamExtract. </br></br>';
        }
        return false;
    }
    if ($GLOBALS['DEBUG']) {
        echo 'Finished running UpstreamExtract. </br></br>';
    }
    return false;

}

//Extractor for goMovies_sx
function UpCloudExtract($url, $tSite, $referer)
{
    global $timeOut;

    if ($GLOBALS['DEBUG']) {
        echo "Started UpCloudExtract for $tSite. </br></br>";
    }

    // Parse the URL
    $urlParts = parse_url($url);

    if ($urlParts !== false && isset($urlParts['path'])) {
        // Split the path into segments
        $pathSegments = explode('/', $urlParts['path']);

        // Get the last segment (id)
        $id = end($pathSegments);

        // Construct the new URL
        $outputUrl = "{$urlParts['scheme']}://{$urlParts['host']}/ajax/embed-4/getSources?id=$id";

        if ($GLOBALS['DEBUG']) {
            echo "UpCloudExtract - Output URL: $outputUrl </br></br>";
        }
    } else {

        if ($GLOBALS['DEBUG']) {
            echo "UpCloudExtract: Invalid URL for $tSite. </br></br>";
        }

        return false;
    }

    try {
        $context = stream_context_create(['http' => ['timeout' => $timeOut, 'header' =>
            "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0\r\n" .
            "X-Requested-With: XMLHttpRequest\r\n" . "Referer: $referer\r\n", ], ]);

        $response = @file_get_contents($outputUrl, false, $context);

        if ($response === false) {
            throw new Exception('HTTP Error: UpCloudExtract');
        }
        if ($GLOBALS['DEBUG']) {
            print_r('UpCloudExtract Json sources: ' . $response . "</br></br>");
        }

        // Decode the JSON response into an associative array
        $data = json_decode($response, true);

        // Decode the JSON response into an associative array
        $data = json_decode($response, true);

        if ($data !== null) {
            if (isset($data['sources'])) {
                if (is_array($data['sources'])) {
                    // Handle multiple sources (an array)
                    $firstSource = $data['sources'][0]; // Get the first source from the array
                } else {
                    // Handle a single source (a string)
                    $firstSource = $data['sources']; // The entire source is a single string
                }

                $getKeyset = extractUpCloudKey();				
				
				
				if ($response === false) {
					throw new Exception('HTTP Error: Couldn\'t get decryption key.');
				}

                return decryptUpcloudSource($firstSource, $getKeyset);
            } else {
                if ($GLOBALS['DEBUG']) {
                    echo "Error: 'sources' key not found. </br></br>";
                }
                return false;
            }
        } else {
            if ($GLOBALS['DEBUG']) {
                echo "Error: Invalid JSON. </br></br>";
            }
            return false;
        }
    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running UpCloudExtract. </br></br>';
        }
        return false;
    }

	return false;
}

//Extractor for upMovies_to
function ePlayVidExtract($url, $tSite, $referer)
{
    global $timeOut;

    try {
		$context = stream_context_create([
			'http' => [
				'timeout' => $timeOut,
				'header' =>
					"User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0\r\n" .
					"Referer: $referer",
			],
		]);

        $response = @file_get_contents($url, false, $context);

        if ($response === false) {
            throw new Exception('HTTP Error: eplayvidExtact');
            if ($GLOBALS['DEBUG']) {
                echo 'Error: ' . $error->getMessage() . "</br></br>";
            }
        }

        if (preg_match('#(?<=<source src=")[\s\S]*?(?=")#', $response, $matches)) {

            if ($GLOBALS['DEBUG']) {
                echo "Video link: " . $matches[0] . "<br><br>";
            }
			//Run link checker before returning.
			$urlData = $matches[0] .
                "|Referer='https://eplayvid.net/'|User-Agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0'|Origin='https://eplayvid.net/'";
				
			$lCheck = checkLinkStatusCode($urlData);
			if ($lCheck == true){
				return 'video_proxy.php?data=' . base64_encode($urlData);
			} else {
				return false;
			}
			
						
        }


    }
    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running ePlayVid. </br></br>';
        }
        return false;
    }

    return false;

}

function streamtapeExtract($url, $tSite, $referer)
{
    global $timeOut;

    $url = str_replace('/v/', '/e/', $url);
	
    if ($GLOBALS['DEBUG']) {
        echo "Started streamtapeExtract for $tSite. </br></br>";
    }

    try {
        $context = stream_context_create(['http' => ['timeout' => $timeOut, 'header' =>
            "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0\r\n" .
            "Referer: " . $referer, ], ]);

        $response = @file_get_contents($url, false, $context);		

        if ($response === false) {
            throw new Exception('HTTP Error: streamtapeExtract');
        }

        $parsed_url = parse_url($url);
		

        if (preg_match_all('#(?<=innerHTML = ").*?(?=;)#', $response, $matches) && preg_match('#.*?(?=")#', $matches[0][0], $firstPart) && isset($parsed_url['scheme']) && isset($parsed_url['host'])) {			
		
			if (preg_match("/(?<=\(')(.*?)(?='\)).*?substring\((\d+)\).*?substring\((\d+)\)/", $matches[0][0], $urlMatches)) {				

				$urlPart = $urlMatches[1]; // The URL part
				$firstSubstrIndex = (int)$urlMatches[2]; // First substring index
				$secondSubstrIndex = (int)$urlMatches[3]+1; // Second substring index

				$finalIndex = $firstSubstrIndex + $secondSubstrIndex;
				$urlPart = substr($urlPart, $finalIndex);
				
			} else {
				throw new Exception("Couldn't form the streaming link in streamtapeExtract for $tSite");		
				
			}

            $sourceUrl = $firstPart[0]. $urlPart . '&stream=1';
			
			$parsedSource = parse_url($sourceUrl);
			
			if (!isset($parsedSource['scheme'])) {
				
				$sourceUrl = $parsed_url['scheme'] . '://' . ltrim($sourceUrl, '/');
			}

            if ($GLOBALS['DEBUG']) {
                echo "Video link: " . $sourceUrl . "<br><br>";
            }
            return $sourceUrl;

        } else {
            throw new Exception("Couldn't extract the source link in streamtapeExtract for $tSite");
        }

    }

    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running streamtapeExtract. </br></br>';
        }
        return false;
    }
    if ($GLOBALS['DEBUG']) {
        echo 'Finished running streamtapeExtract. </br></br>';
    }
    return false;

}

function vidozaExtract($url, $tSite, $referer)
{
    global $timeOut;

    if ($GLOBALS['DEBUG']) {
        echo "Started vidozaExtract for $tSite. </br></br>";
    }

    try {
        $context = stream_context_create(['http' => ['timeout' => $timeOut, 'header' =>
            "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0\r\n" .
            "Referer: " . $referer, ], ]);

        $response = @file_get_contents($url, false, $context);		

        if ($response === false) {
            throw new Exception('HTTP Error: vidozaExtract');
        }		

        if (preg_match('#(?<=\[{ src: ").*?(?=")#', $response, $matches)) {			
		

            $DirectLink = $matches[0];			

            //Run link checker before returning.
            $urlData = $DirectLink . "|Referer='" . $referer .
                "'|User-Agent='Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/117.0'";

            $lCheck = checkLinkStatusCode($urlData);
            if ($lCheck == true) {

            if ($GLOBALS['DEBUG']) {
                echo "Video link: " . $DirectLink . "<br><br>";
            }
                return 'video_proxy.php?data=' . base64_encode($urlData);

            } else {
                return false;
            }

        } else {
            throw new Exception("Couldn't extract the source link in vidozaExtract for $tSite");
        }

    }

    catch (exception $error) {
        if ($GLOBALS['DEBUG']) {
            echo 'Error: ' . $error->getMessage() . "</br></br>";
            echo 'Finished running vidozaExtract. </br></br>';
        }
        return false;
    }
    if ($GLOBALS['DEBUG']) {
        echo 'Finished running vidozaExtract. </br></br>';
    }
    return false;

}

////////////////////////////// Caching ///////////////////////////////

function writeToCache($key, $value, $expires = null)
{
    global $expirationDuration;	

	if ($expires === null) {
        $expires = $expirationDuration;
    }

    // Specify the cache file path
    $cacheFilePath = 'cache.json';

    // Check if the cache file exists or create it if not
    if (!file_exists($cacheFilePath)) {
        file_put_contents($cacheFilePath, '{}');
    }

    // Get the current timestamp
    $now = time();
    $expirationTime = $now + $expires;

    // Serialize the value to a JSON string
    $serializedValue = json_encode($value);

    // Read existing cache data
    $cacheData = json_decode(file_get_contents($cacheFilePath), true) ? : [];

    // Update the cache data with the new value
    $cacheData[$key] = ['value' => $serializedValue, 'expirationTime' => $expirationTime, ];

    // Write the updated cache data back to the file
    file_put_contents($cacheFilePath, json_encode($cacheData));

    if ($GLOBALS['DEBUG']) {
        echo 'Added to Cache - Key: ' . $key . ' Value: ' . json_encode($value) .
            "</br></br>";
    }
}

function readFromCache($key)
{
    // Specify the cache file path
    $cacheFilePath = 'cache.json';

    // Check if the cache file exists or create it if not
    if (!file_exists($cacheFilePath)) {
        file_put_contents($cacheFilePath, '{}');
    }

    // Read existing cache data
    $cacheData = json_decode(file_get_contents($cacheFilePath), true) ? : [];

    if (isset($cacheData[$key])) {
        $parsedData = $cacheData[$key];

        // Get the current timestamp
        $now = time();

        // Check if the data has expired
        if ($now <= $parsedData['expirationTime']) {
            // Deserialize the JSON string back to an object
            $deserializedValue = json_decode($parsedData['value'], true);

            if ($GLOBALS['DEBUG']) {
                echo 'Read from Cache - Key: ' . $key . ' - Value: ' . json_encode($deserializedValue) .
                    "</br></br>";
            }

            return $deserializedValue;
        } else {
            // Data has expired, remove it from the cache
            unset($cacheData[$key]);

            // Write the updated cache data back to the file
            file_put_contents($cacheFilePath, json_encode($cacheData));
        }
    }

    // Cache miss or expired data, or the cache file doesn't exist
    return null;
}

function cleanupCacheFiles()
{
    global $cacheSize;
    // List of cache files to check
    $cacheFiles = ['html_cache.txt', 'cache.json', 'access.log'];

    foreach ($cacheFiles as $file) {
        // Check if file exists
        if (file_exists($file)) {
            // Get file size in bytes
            $fileSize = filesize($file);

            $maxSize = $cacheSize * 1024 * 1024;

            // If file size is greater than 30 MB, clear the file
            if ($fileSize > $maxSize) {
                if ($GLOBALS['DEBUG']) {
                    echo "Cache file $file is larger than " . $cacheSize .
                        "MB. Clearing the file.<br>";
                }

                // Clear the file contents
                file_put_contents($file, '');
            }
        }
    }
}

////////////////////////////// Logging ///////////////////////////////

function logDetails($siteFunction, $extractor, $status, $title, $pageUrl, $videoUrl, $type, $movieIds, $seriesCode = 'n/a', $logFilePath = 'detailed_log.html') {
	 $time = date('Y-m-d h:i:s A');	 
		
	// Create the access URL
	$accessUrl = locateBaseURL() . basename($_SERVER['SCRIPT_NAME']);

	// Append 'dev=true' only if it's not already in the query string
	if (!empty($_SERVER['QUERY_STRING'])) {
		// If the query string exists, append it, and add 'dev=true' if it's not part of the query string
		$accessUrl .= '?' . $_SERVER['QUERY_STRING'];
		if (strpos($_SERVER['QUERY_STRING'], 'dev=true') === false) {
			$accessUrl .= '&dev=true';
		}
	} else {
		// If there is no query string, just add '?dev=true'
		$accessUrl .= '?dev=true';
	}
	
	if ($videoUrl !== 'n/a' && !parse_url($videoUrl, PHP_URL_HOST)) {
		$videoUrl = $domain . $basePath . $videoUrl;
	}	
	 
    // Styles for the table
    $style = "<style>
        table { width: 100%; border-collapse: collapse; table-layout: fixed; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; overflow: hidden; text-overflow: ellipsis;}		
        th { background-color: #f2f2f2; }
        tr:nth-child(even) { background-color: #f9f9f9; }
        a { color: #0645ad; text-decoration: none; }
        a:hover { text-decoration: underline; }
        .status-success { color: green; }
        .status-failed { color: red; }
		
		</style>";

    // DOMDocument setup
    $refreshInterval = 5000; // Refresh interval in milliseconds (5000ms = 5s)

    $doc = new DOMDocument();
    @$doc->loadHTMLFile($logFilePath) || @$doc->loadHTML('
    <html>
        <head>
            <title>Detailed Logs</title>
            ' . $style . '
		<script>
			setTimeout(function() {
				location.reload();
			}, ' . $refreshInterval . ');

			function openPopup(divId) {   
				var content = document.getElementById(divId).innerHTML;    
				var windowFeatures = "width=300,height=370,scrollbars=yes,resizable=no,toolbar=no,location=no,directories=no,status=no,menubar=no";    
				var popupWindow = window.open("", "_blank", windowFeatures);
				popupWindow.document.write("<html><head><title>Torrent Extractors<\/title><\/head><body>" + content + "<\/body><\/html>");
				popupWindow.document.close();
				if (window.focus) {
					popupWindow.focus();
				}
			}
		</script>

        </head>
        <body>
            <table>
                <thead></thead>
                <tbody></tbody>
            </table>
        </body>
    </html>');

    // Get or create the table and tbody
    $table = $doc->getElementsByTagName('table')->item(0);
    $tbody = $table->getElementsByTagName('tbody')->item(0);

    // Create header if it does not exist
    if ($table->getElementsByTagName('thead')->item(0)->childNodes->length === 0) {
        $headers = ['Time', 'Site Function', 'Extractor', 'Status', 'Title', 'Page Url', 'Video URL', 'Access URL', 'Type', 'TMDB', 'Series Code'];
        $headerRow = $doc->createElement('tr');
        foreach ($headers as $header) {
            $th = $doc->createElement('th', $header);
            $headerRow->appendChild($th);
        }
        $table->getElementsByTagName('thead')->item(0)->appendChild($headerRow);
    }

    // Create a new row
    $row = $doc->createElement('tr');
    $rowData = [$time, $siteFunction, $extractor, $status, $title, $pageUrl, $videoUrl, $accessUrl, $type, $movieIds, $seriesCode];
	

foreach ($rowData as $index => $data) {
    $td = $doc->createElement('td');
    $td->setAttribute('style', 'max-width: 220px; overflow: hidden; text-overflow: ellipsis;');

    // Check if the current cell should contain HTML content from $extractor
    if ($index == 2 && $data != 'n/a') { // Assuming $extractor content is at index 2
        // Create a DocumentFragment to hold the HTML content
        $fragment = $doc->createDocumentFragment();
        @$fragment->appendXML($data); // Suppress warnings for invalid HTML
        $td->appendChild($fragment);
    } else {
        // Correctly handle URLs; skip creating an anchor element if the data is 'n/a'
        if (in_array($index, [5, 6, 7]) && $data !== 'n/a') { // For Page URL, Video URL, and Access URL
            $a = $doc->createElement('a');
            $a->setAttribute('href', $data);
            $a->setAttribute('target', '_blank');
            $a->appendChild($doc->createTextNode($data));
            $td->appendChild($a);
        } else { // For non-URLs or 'n/a', just set the text content
			if ($index == 3) { // Additional styling for Status column
				$tdColor = ($data === 'successful' ? 'green' : ($data === 'failed' ? 'red' : 'black'));
				$td->setAttribute('style', "max-width: 200px; overflow: hidden; text-overflow: ellipsis; color: $tdColor;");
				$td->textContent = $data; // Set text for status
			} else if ($index === 9) {
				// Create link for index 9
				$a = $doc->createElement('a');          
				
				if ($type === 'movies') {
					$url = 'https://www.themoviedb.org/movie/' . $data;
				} else {
					$url = 'https://www.themoviedb.org/tv/' . $data;
				}

				$a->setAttribute('href', $url);
				$a->setAttribute('target', '_blank');
				$a->appendChild($doc->createTextNode($data));
				$td->appendChild($a);
			} else {
				// For other indices, just set text
				$td->textContent = $data;
			}
				
        }
    }
    $row->appendChild($td);
}

    // Insert the new row at the top of the tbody
    if ($tbody->childNodes->length > 0) {
        $tbody->insertBefore($row, $tbody->childNodes->item(0));
    } else {
        $tbody->appendChild($row);
    }

    // Keep only the latest 300 rows in tbody
    while ($tbody->childNodes->length > 300) {
        $tbody->removeChild($tbody->lastChild);
    }

    // Save the updated HTML to the file
    $doc->saveHTMLFile($logFilePath);
}







?>